
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Benutzerrechte') %]</span>
    </div>

    <div class="card-body">


        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-sm-6">
                        <span class="fcs-card-title h4">[% $user->gettext('Benutzerrechte') %]</span>
                    </div>
                    <div class="col-sm-6 text-end">
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=userGroups" target="_top">[% $user->gettext('Nur Gruppen') %]</a></span>
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=justUsers" target="_top">[% $user->gettext('Ohne Gruppen') %]</a></span>                        
                        <span class="btn btn-outline-secondary active"><a href="index.php?module=reporting&class=userrightreport" target="_top">[% $user->gettext('Mit Gruppen') %]</a></span>
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=GroupRightMatrix" target="_top">[% $user->gettext('Gruppenrechte') %]</a></span>

                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&excel" target="_blank">Excel</a></span>

                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class='table-responsive' style="max-height: 75vh;">

                    <table class='table table-bordered'>
                        <thead>
                            <tr>
                                <th>Sektion</th>
                                <th>Segment</th>
                                <th>Recht</th>
                                    [% foreach from=$UserByGroups item=Group key=GroupName %]
                                    <th colspan='[% $Group.Users|fcs_count%]'>[% $GroupName %]</th>
                                    [% /foreach %]
                            </tr>
                            <tr>
                                <th colspan='3'></th>
                                    [% foreach from=$UserByGroups item=Group key=GroupName %]
                                        [% foreach from=$Group.Users item=User %]
                                        <th>[% $User.Name %]</th>
                                        [% /foreach %]
                                    [% /foreach %]
                            </tr>
                        </thead>
                        [% assign var=actualSection value= $Right.section  %]
                        [% assign var=actualSegment value= $Right.segment  %]
                        [% foreach from=$Rights item=Right key=RightID %]   

                            <tr>
                                [% if $actualSection != $Right.section  %]
                                    [% assign var=actualSection value= $Right.section  %]                                 
                                    <td rowspan="[% $Count.Sections[$Right.section] %]">[% $Right.section %]</td>
                                [% /if %]
                                [% if $actualSegment != $Right.segment  %]
                                    [% assign var=actualSegment value= $Right.segment  %]                             
                                    <td rowspan="[% $Count.SectionSegemnts[$Right.section].Segment[$Right.segment] %]">[% $Right.segment %]</td>
                                [% /if %]      
                                <td>[% $Right.rightname %]</td>

                                [% foreach from=$UserByGroups item=Group key=GroupName %]
                                    [% foreach from=$Group.Users item=User %]
                                        <td>[% if $User.Rights.$RightID %]x[% else %]&nbsp;[% /if %]</td>
                                    [% /foreach %]
                                [% /foreach %]


                            </tr>
                        [% /foreach %]
                    </table>



                </div>


            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {
        $('.tableAA').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            searching: false,
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 200,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    })
</script>
