<!-- Component Default begin -->
<script language="JavaScript" src="modules/reporting/javascript/reporting.js" type="text/JavaScript"></script>
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>
<!-- ###CONTENT### begin -->
<form  action="index.php?module=reporting&event=move" method="post" name="hm" id="HM-Form-Report" enctype="multipart/form-data" class="form-inline">
    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="sorting" id="sorting" value="[% $sorting %]" />
    <input type="hidden" name="sortOrder" id="sortOrder" value="[% $sortOrder %]" />
    <input type="hidden" name="action" id="action" value="" />     
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">
                [% $user->gettext('Tickets weitergegeben')%]
        </div>
        <div class="card-body">
            [% if !$print%]
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body"> 
                    <div class="col-lg-9">
                        <div class="form-group">
                            <label class="control-label">[% $user->gettext('Filter')%]:</label>
                            <input type="text" class="form-control" name="filter" id="filter" value="[% $smarty.session.Reporting.filter %]" >
                        </div>

                        <div class="form-group">
                            <label class="control-label">[% $user->gettext('Von')%]:</label>
                            <input type="text" class="form-control datepicker" value="[% $smarty.session.Reporting.startdate %]" name="startdate" id="startdate" onkeyup="keyEvent(event)" />
                        </div>

                        <div class="form-group">
                            <label class="control-label">[% $user->gettext('Bis')%]:</label>
                            <input type="text" class="form-control datepicker" value="[% $smarty.session.Reporting.enddate %]" name="enddate" id="enddate" onkeyup="keyEvent(event)" />
                        </div>

                        <div class="form-group">
                            <select class="form-control" name="period" onchange="changePeriod(this);">
                                <option value="0" selected="selected">[% $user->gettext('Zeitraum') %]</option>
                                <option value="99" >[% $user->gettext('Heute') %]</option>
                                <option value="1" >[% $user->gettext('Gestern') %]</option>
                                <option value="2" >[% $user->gettext('Letzte Woche') %]</option>
                                <option value="3" >[% $user->gettext('Letzten Monat') %]</option>
                                <option value="4" >[% $user->gettext('Letztes Jahr') %]</option>
                                <option value="5" >[% $user->gettext('Aktuelles Jahr') %]</option>
                    
                            </select>
                        </div>
                        <div class="form-group">
                            <input type="button" value="[% $user->gettext('Anzeigen') %]" class="btn btn-outline-primary" onclick="setAction(''); $('#HM-Form-Report').submit();"/>
                        </div>
                    </div>
                    <div class="col-lg-3 text-end">
                        <div class="btn-group">
                            <a href="index.php?module=reporting&amp;event=move&amp;action=print" data-fancybox-type="iframe" class="btn btn-outline-primary dialog"><span>[% $user->gettext('DRUCKEN') %]</span></a>
                        </div>
                    </div>

                </div>
            </div>
            [% /if %]
            <div class="card panel-info shadow-sm rounded">

                <div class="card-header">
                    [% if !$print%]
                        <span class="fcs-card-title h3">[% $entries %] [%$user->gettext('Eintr&auml;ge gefunden')%]</span>
                        [% else %]
                            <div class="row">
                                <div class="col-sm-8">
                                    <span class="fcs-card-title h3">[% $entries %] [%$user->gettext('Eintr&auml;ge gefunden')%]</span>
                                </div>
                                <div class="col-sm-8">
                                    <input type="button" class="btn btn-outline-primary hidden-print" onclick="print();" value="[% $user->gettext('Drucken') %]" />
                                </div>
                            </div>
                            [% /if %]
                    
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr class="fields">

                                    <th class="text-center" onclick="">
                                        [% $user->gettext('Benutzer') %]
                                    </th>
                                    
                                    <th class="text-center" >
                                        [% $user->gettext('Initiale Supporter in (Tickets)') %]
                                       
                                    </th>
                                    <th class="text-center" >
                                        [% $user->gettext('Weitergegebene Tickets') %]
                                       
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$tickets item=ticket %]
                                    <tr >
                                        <td class="text-center">[% $ticket.name %]</td>
                                        <td class="text-center">[% $ticket.anzahlinitiale %]</td>
                                        <td class="text-center">[% $ticket.anzahlweitergabe %]</td>
                                    </tr>
                                [% foreachelse %]
                                    <tr>
                                        <td class="text-center" colspan="4" style="text-align:center !important;">[% $user->gettext('Keine Tickets im Zeitraum gefunden') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>

                       

                    </div>
                </div>
            </div>

        </div>
    </div>




    <script language="JavaScript" type="text/JavaScript">
        
  

        function changePeriod(element) {

        var value = element.options[element.selectedIndex].value;
        var startdate = document.forms['hm'].elements['startdate'];
        var enddate = document.forms['hm'].elements['enddate'];
        var now = new Date();
        var Tag = now.getDate();
        var Monat = now.getMonth();

        if (value == 99) {
        startdate.value = "[% $today %]";
        enddate.value = startdate.value;
        } else if (value == 1) {
        startdate.value = "[% $yesterday %]";
        enddate.value = startdate.value;
        } else if (value == 2) {
        startdate.value = "[% $lastweek %]";
        enddate.value = "[% $today %]";
        } else if (value == 3) {
        startdate.value = "[% $lastmonth_start %]";
        enddate.value = "[% $lastmonth_end %]";
        } else if (value == 4) {
            startdate.value = "[% $lastyear_start %]";
            enddate.value = "[% $lastyear_end %]";
        } else if (value == 5) {
            startdate.value = "[% $currentyear_start %]";
            enddate.value = "[% $currentyear_end %]";
        }
        }

        $(".datepicker").datepicker();

    </script>

    <!-- Component Default end -->

</form>

<form action="index.php?module=reporting&event=showTickets" method="post" name="lform" target="_blank" />
<input type="hidden" name="assign" id="listuid" value="" />
<input type="hidden" name="Sorting" value="[% $sorting %]" />
<input type="hidden" name="SortOrder" value="[% $sortOrder %]" />

<script>
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            [% if !$print %]
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            [% else %]
             buttons: [
//               
            ],
            searching: false;
            [% /if %]
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    })    
</script>
