<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .table th{
        cursor: pointer;
    }
    .popover{
        max-width: 70%; /* Max Width of the popover (depending on the container!) */
    }

</style>
<form action="index.php?module=reporting&event=getChannelReport" method="post" name="hm" id="hm" enctype="multipart/form-data" class="form-inline" >

    <input type="hidden" id="sort" name="sort" value="[% $sort %]" />
    <input type="hidden" id="sortorder" name="sortorder" value="[% $sortorder %]" />
    <input type="hidden" id="message" name="message" value="0" />
    <input type="hidden" id="type" name="type" value="" />
    <input type="hidden" id="pos" name="pos" value="" />
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[% $user->gettext('Tickets je Ticketerstellkanal') %]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <link rel="stylesheet" href="includes/js/bootstrap-select-1.12.4/dist/css/bootstrap-select.min.css">

                    <!-- Latest compiled and minified JavaScript -->
                    <script src="includes/js/bootstrap-select-1.12.4/dist/js/bootstrap-select.min.js"></script>

                    <!-- (Optional) Latest compiled and minified JavaScript translation files -->
                    <script src="includes/js/bootstrap-select-1.12.4/dist/js/i18n/defaults-[% if $user->language_type == "de" %]de_DE[% else %]en_US[% /if %].min.js"></script>

                    <div class="fcs-form-padding">
                        <div class="form-group">
                            <label class="control-label">[% $user->gettext('Zeitraum')%]</label>

                            <div class="form-group">
                                <div class="input-group">
                                    <span class = "input-group-text">[% $user->gettext('Von')%] </span>
                                    <input type="text" value="[% if $startdate %][% $startdate|date_format:"%d.%m.%Y" %][% /if %]" autocomplete="off"  name="startdate" class="form-control datepicker" onkeyup="keyEvent(event)" />
                                    <span class = "input-group-text">[% $user->gettext('Bis')%] </span>
                                    <input type="text" value="[% if $enddate %][% $enddate|date_format:"%d.%m.%Y" %][% /if %]" autocomplete="off"  name="enddate" class="form-control datepicker" onkeyup="keyEvent(event)" />
                                </div>
                            </div>
                            <select class="form-control" name="period" onchange="changePeriod(this);">
                                <option value="0" [% if !$period %]selected="selected" [% /if %]>[% $user->gettext('Zeitraum') %]</option>
                                <option value="1" [% if $period == 1 %]selected="selected" [% /if %]>[% $user->gettext('Heute') %]</option>
                                <option value="2" [% if $period == 2 %]selected="selected" [% /if %]>[% $user->gettext('Gestern') %]</option>
                                <option value="3" [% if $period == 3 %]selected="selected" [% /if %]>[% $user->gettext('Letzte Woche') %]</option>
                                <option value="4" [% if $period == 4 %]selected="selected" [% /if %]>[% $user->gettext('Letzten Monat') %]</option>
                                <option value="5" [% if $period == 5 %]selected="selected" [% /if %]>[% $user->gettext('Letztes Jahr') %]</option>
                                <option value="6" [% if $period == 6 %]selected="selected" [% /if %]>[% $user->gettext('Aktuelles Jahr') %]</option>
                                [% if $timing_add %]
                                    [% foreach from=$timing_add key=k item=v %]
                                        <option value="[% $v.id %]">[% $k %]</option>
                                    [% /foreach %]
                                [% /if %]                         
                            </select>
                        </div>

                        <div class="form-group">
                            <button class="btn btn-outline-primary" onclick=""><span class="fa fa-search"></span></button>
                        </div>

                    </div>
                    <script>

                        $('.selectpicker').selectpicker();
                        $('.selectpicker').on('hide.bs.select', function (e, clickedIndex, isSelected, previousValue) {
                            document.hm.submit();
                        })
                    </script>
                </div>
            </div>


            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">

                        [% $user->gettext('Ticketerstellkanäle') %]

                    </span>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr class="fields>">
                                    <th class="sort" id="id">[% $user->gettext('Kanal') %]</th>

                                    <th class="sort" id="cnttickets">[% $user->gettext('Anzahl Tickets') %]</th>

                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$channels item=$channel %]
                                    <tr>
                                        <td>[% $channel.channel %]</td>
                                        <td>[% $channel.countticket %]</td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="2" style="text-align:center !important">[% $user->gettext('Es wurden keine Tickets im System gefunden...') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>



    </div>
</form>



<script>

    $(".datepicker").datepicker();
    var current_sort = $("#sort").val();
    var current_sortorder = $("#sortorder").val();

    showSortIcon();



    $(".sort").on("click", function (e) {
        var sort = $(this).attr('id');
        var sortorder = 'asc';
        if (current_sort === sort) {
            if (current_sortorder === 'asc') {
                sortorder = 'desc';
            } else {
                sortorder = 'asc';
            }
        }
        $("#sort").val(sort);
        $("#sortorder").val(sortorder);
        submitForm();
    })

    function showSortIcon() {
        var content = $("#" + current_sort).html();
        if (current_sortorder == 'desc') {
            content += '<span class="fa fa-chevron-down"></span>';

        } else {
            content += '<span class="fa fa-chevron-up"></span>';
        }
        $("#" + current_sort).html(content);
    }

    function setActive(id) {
        var isChecked = 0;
        var info = "";
        if ($('#checbox_active_' + id).is(":checked")) {
            isChecked = 1
        }
        ;
        if (isChecked == 1) {
            info = "[% $user->gettext('aktiviert')%]";
        } else {
            info = "[% $user->gettext('deaktiviert')%]";
        }
        $.post('index.php?module=field&event=setActive', {id: id, active: isChecked}, function (data) {
            if (data == 1) {
                noty({
                    text: "[% $user->gettext('Feld " +info+ ".') %]",
                    type: 'success',
                    timeout: notifyTimeout
                });
            } else {
                noty({
                    text: "[% $user->gettext('Feld kann momentan nicht aktualisiert werden.') %]",
                    type: 'error',
                    timeout: notifyTimeout
                });
            }

        })
    }

    function changePeriod(element) {

        var value = element.options[element.selectedIndex].value;
        var startdate = document.forms['hm'].elements['startdate'];
        var enddate = document.forms['hm'].elements['enddate'];
        var now = new Date();
        var Tag = now.getDate();
        var Monat = now.getMonth();

        if (value == 1) {
            startdate.value = "[% $today %]";
            enddate.value = startdate.value;
        } else if (value == 2) {
            startdate.value = "[% $yesterday %]";
            enddate.value = startdate.value;
        } else if (value == 3) {
            startdate.value = "[% $lastweek %]";
            enddate.value = "[% $today %]";
        } else if (value == 4) {
            startdate.value = "[% $lastmonth_start %]";
            enddate.value = "[% $lastmonth_end %]";
        } else if (value == 5) {
            startdate.value = "[% $lastyear_start %]";
            enddate.value = "[% $lastyear_end %]";
        } else if (value == 6) {
            startdate.value = "[% $currentyear_start %]";
            enddate.value = "[% $currentyear_end %]";
        }
    [% if $timing_add %]
        [% foreach from=$timing_add item=timing2 %]
        else if (value == [% $timing2.id %]) {

            startdate.value = "[% $timing2.start %]";
            enddate.value = "[% $timing2.end %]";
        }
        [% /foreach %]
    [% /if %]
        //document.hm.submit();
    };
    
        $(document).ready(function () {

        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'excel',
                'print',
                'pdfHtml5'
            ],
    columnDefs: [
      {targets: '_all', render: function(data, type, row, meta) {
        var api = $('#example').DataTable();
        return type === 'export'? $(api.cell(meta.row, meta.col).node()).attr('data-export') : data;
      }
      }
    ],            
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });

    });
</script>
