<!-- ###CONTENT### begin -->
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Servicetyp') %]</span>
    </div>
    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-6">
                        <form  action="" method="post" name="hm" id="hm" enctype="multipart/form-data" class="form-inline form-horizontal">
                            <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
                            <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />
                            <input type="hidden" name="pos" value="[% $pos %]" id="pos">
                            <div class="form-group row mb-3">
                                <label for="entries_per_page" class="col-lg-8 control-label">[% $user->gettext('Eintr&auml;ge pro Seite') %]:</label>
                                <div class="col-lg-4">
                                    <select size="1" name="entries_per_page" id="entries_per_page" onchange="document.hm.submit();" class="form-control">
                                        <option value="10" [% if $entries_per_page == 10 %]selected="selected"[% /if %]>10</option>
                                        <option value="20" [% if $entries_per_page == 20 %]selected="selected"[% /if %]>20</option>
                                        <option value="50" [% if $entries_per_page == 50 %]selected="selected"[% /if %]>50</option>
                                        <option value="100" [% if $entries_per_page == 100 %]selected="selected"[% /if %]>100</option>
                                    </select>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-lg-6 text-end">
                        <div class="btn-group">
                            [% if $user->hasRight(40) %]
                                <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Neuer Servicetyp') %]" onclick="window.location.href = 'index.php?module=services&class=servicetype&event=create'">
                            [% /if %]
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Servicetypenliste') %]</span>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr class="fields">                       
                            <th style="cursor:pointer;" onclick="document.getElementById(
                                [% if $sort == "Title" %]
                                'sortorder').value = '[% if $sortorder == "DESC" %]ASC[% else %]DESC[% /if %]'
                                [% else %]
                                        'sort').value = 'Title'
                                [% /if %];
                                        submitForm();">
                                [% $user->gettext('Titel') %]
                                [% if $sort == "Title" %]&nbsp;<span class="fa fa-chevron-[% if $sortorder == "DESC" %]down[% else %]up[% /if %]"></span>[% /if %]
                            </th>
                            <th style="cursor:pointer;" onclick="document.getElementById(
                                [% if $sort == "Active" %]
                                'sortorder').value = '[% if $sortorder == "DESC" %]ASC[% else %]DESC[% /if %]'
                                [% else %]
                                        'sort'
                                                ).value = 'Active'
                                [% /if %];
                                        submitForm();">
                                [% $user->gettext('Aktiv') %]
                                [% if $sort == "Active" %]&nbsp;<span class="fa fa-chevron-[% if $sortorder == "DESC" %]down[% else %]up[% /if %]"></span>[% /if %]
                            </th>
                            <th>[% $user->gettext('Anzahl Services') %]</th>
                            <th>&nbsp;</th>
                        </tr>
                    </thead>
                    <tbody>

                        [% foreach from=$ServiceTypes item=servicetype %]
                            <tr>
                                <td>&nbsp;[% $servicetype.title %]&nbsp;</td>
                                <td class="center">&nbsp;<span class="fa fa-[% if $servicetype.active == 1 %]ok[% else %]remove[%/if%]" style="color:[% if $servicetype.active == 1 %] green [% else %] red [% /if %];"></span>&nbsp;</td>&nbsp;</td>   
                                <td>&nbsp;<a href='index.php?module=services&class=service&servicetypeid[]=[% $servicetype.id %]'>[% $servicetype.cntservices %]</a>&nbsp;</td>
                                <td>
                                    <div style="text-align:center; white-space: nowrap;">
                                        [% if $servicetype.cntservices < 1 %]
                                            <a href="index.php?module=services&class=servicetype&event=remove&id=[% $servicetype.id %]" class="btn btn-outline-secondary" ><span class="fa fa-trash" title="[%$user->gettext('L&ouml;schen')%]"></span></a>
                                            [% /if %]
                                        <a href="index.php?module=services&class=servicetype&event=edit&id=[% $servicetype.id %]" class="btn btn-outline-secondary"><span class="fa fa-pencil" title="[%$user->gettext('Bearbeiten')%]"></span></a>
                                    </div>
                                </td>
                            </tr>
                        [% foreachelse %]
                            <tr class="odd">
                                <td colspan="9">
                                    <div align="center">[% $user->gettext('Keine Eintr&auml;ge vorhanden') %]</div>
                                </td>
                            </tr>                                
                        [% /foreach %]
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="15">
                                [% $Paging %]
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">

    function switchPage(pos) {
        document.getElementById("pos").value = pos;
        submitForm();
    }
    $(".multiple").multiselect({
        buttonClass: 'form-select',
    templates: {
        button: '<button type="button" class="multiselect dropdown-toggle" data-bs-toggle="dropdown"><span class="multiselect-selected-text"></span></button>',
    },
        checkAllText: '[% $user->gettext("Alle") %]',
        uncheckAllText: '[% $user->gettext("Keine") %]',
        noneSelectedText: '[% $user->gettext("Wählen Sie") %]',
        selectedText: '# [% $user->gettext("gewählt") %]',
        selectedList: 1,
        header: true,
        multiple: false
    });

</script>
<!-- Component User begin -->

