
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h3 class="fcs-card-title h3">[% $user->gettext('Workflow-Benachrichtigungen anpassen') %]</h3>
    </div>
    <div class="card-body">
        <div>

            <!-- Nav tabs -->
            <ul class="nav nav-tabs" role="tablist">
                [% foreach item=Template from=$MailTemplates name=TemplateTitels %]
                    <li role="presentation" id="list-[% $Template.mailtype %]" class="nav-item"><a  class="nav-link [% if $Template.mailtype== $current_mailtype %]active[% /if %]" onclick="$('.tab-mailtype').hide(); $('#tab-[% $Template.mailtype %]').show();" aria-controls="[% $Template.mailtype %]" role="tab" data-bs-toggle="tab">[% $user->gettext($Template.mailtype) %] 
                            [% if $Template.active %]<span class="fa fa-check"></span>[% /if %]</a></li>                        
                        [% /foreach %]      
            </ul>

            <!-- Tab panes -->
            <div class="tab-content">

                [% foreach item=Template from=$MailTemplates name=TemplateItems %]
                    <div role="tabpanel" class="tab-pane [% if $smarty.foreach.TemplateItems.first %]active[% /if %] tab-mailtype" id="tab-[% $Template.mailtype %]">
                        <form action="index.php?module=settings&event=editWFTemplate#tab-[% $Template.mailtype %]" method="POST" name="EditTemplateform" id="EditTemplateform" class="form-horizontal form-label-left">
                            <input type="hidden" name="MailType" id="MailType" value="[% $Template.mailtype %]" />
                            <div class="card panel-info shadow-sm rounded">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <span class="fcs-card-title h4">[% $user->gettext($Template.mailtype) %]</span>
                                        </div>
                                        <div class="col-sm-6 text-end">
                                            <div class="btn-group">
                                                <input type="submit" value="[% $user->gettext('Speichern') %]" class="btn btn-outline-primary btn-sm" />                                  
                                                <a href="index.php?module=settings&event=wfvorschau&template=[% $Template.mailtype %]&mandantid=[%$MandantID%]" value="" class="btn btn-outline-primary btn-sm openInBigIFrameModal">[% $user->gettext('Vorschau') %]</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                [% if $Template.mailtype == 'MailReply' %]
                                    <br/>
                                    <div class="alert alert-info" role="alert">[% $user->gettext('Zur Definition der Reply-Benachrichtigungen gibt es die Funktion "Replytemplate definieren".<br/>Wir empfehlen, diese zu verwenden.') %]</div>
                                [% /if %]
                                <div class="card-body">
                                    <div class="form-group row mb-3">
                                        <label class="col-sm-2 control-label" for="Active">[% $user->gettext('Aktiv') %]</label>                                     
                                        <div class="checkbox col-sm-8">
                                            <input type="checkbox"  id="Active" name="Active" value="1" [% if $Template.active %]checked="checked"[% /if %] style="margin-left: 0px;" />
                                        </div>
                                    </div>
                                    <div class="form-group row mb-3">
                                        <label class="col-sm-2 control-label" for="Subject">[% $user->gettext('Betreff') %]</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="Subject" value="[% $Template.subject %]" />
                                        </div>
                                        <div class="col-sm-1">
                                            <a href="#SubjectPlaceholder" class="btn btn-outline-secondary dialog" >?</a>
                                        </div>
                                    </div>         
                                    <div class="form-group row mb-3">
                                        <label class="col-sm-2 control-label" for="Subject">[% $user->gettext('Inhalt') %]</label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control" name="Content" style="width:100%;min-height: 25em;">[% $Template.content %]</textarea>
                                        </div>
                                        <div class="col-sm-1">
                                            <a href="#ContentPlaceholder" class="btn btn-outline-secondary dialog" >?</a>
                                        </div>
                                    </div>                                         
                                </div>    
                            </div>
                        </form>

                    </div>                           
                [% /foreach %]            
            </div>

        </div>
    </div>
</div> 




<div id="SubjectPlaceholder" style="display:none;">
    <p>[% $user->gettext('Im Betreff der Benachrichtigung können Sie folgende Platzhalter verwenden') %]:</p>
    <ul>
        <li>[% $smarty.ldelim %] TicketID [% $smarty.rdelim %] => [% $user->gettext('TicketID') %]</li>
        <li>[% $smarty.ldelim %] ShortText [% $smarty.rdelim %] => [% $user->gettext('Ticket Kurzbeschreibung') %]</li>
        <li> [% $smarty.ldelim %] WorkflowID [% $smarty.rdelim %] => [% $user->gettext('ID des Workflows') %]</li>
        <li> [% $smarty.ldelim %] WFIDescr [% $smarty.rdelim %] => [% $user->gettext('Name der Workflow-Instanz') %]</li>
        <li> [% $smarty.ldelim %] ActivityTitle [% $smarty.rdelim %] => [% $user->gettext('Titel der Aktivitätsinstanz') %]</li>
        <li> [% $smarty.ldelim %] WorkflowTitle [% $smarty.rdelim %] => [% $user->gettext('Titel der Workflowinstanz') %]</li>
    </ul>
</div>

<div id="ContentPlaceholder" style="display:none;">
    <p>[% $user->gettext('Im Inhalt der Benachrichtigung können Sie folgende Platzhalter verwenden') %]:</p>
    <ul>
       
        <li class="M2T"> [% $smarty.ldelim %]  TicketID [% $smarty.rdelim %] => [% $user->gettext('TicketID') %]</li>
        <li class="M2T"> [% $smarty.ldelim %]  Status [% $smarty.rdelim %] => [% $user->gettext('Ticketstatus') %]</li>
        <li class="M2T"> [% $smarty.ldelim %]  Title [% $smarty.rdelim %] => [% $user->gettext('Tickettitel (Kurzbeschreibung)') %]</li>
        <li class="M2T"> [% $smarty.ldelim %]  Description [% $smarty.rdelim %] => [% $user->gettext('Ticketbeschreibung (erste Bearbeitung)') %]</li>

        <li> [% $smarty.ldelim %]  Priority [% $smarty.rdelim %] => [% $user->gettext('Priorität') %]</li>
        <li> [% $smarty.ldelim %]  Category1 [% $smarty.rdelim %] => [% $user->gettext('Kategorie 1') %]</li>
        <li> [% $smarty.ldelim %]  Category2 [% $smarty.rdelim %] => [% $user->gettext('Kategorie 2') %]</li>
        <li class="M2T"> [% $smarty.ldelim %]  CreateDate [% $smarty.rdelim %] => [% $user->gettext('Erstellungsdatum des Tickets') %]</li>
        <li> [% $smarty.ldelim %]  CreateBy [% $smarty.rdelim %] => [% $user->gettext('Ticketersteller') %]</li>
        <li> [% $smarty.ldelim %]  UpdateDate [% $smarty.rdelim %] => [% $user->gettext('Datum der letzten Bearbeitung') %]</li>
        <li> [% $smarty.ldelim %]  UpdateBy [% $smarty.rdelim %] => [% $user->gettext('Letzter Bearbeiter') %]</li>
        <li> [% $smarty.ldelim %]  TicketExpense [% $smarty.rdelim %] => [% $user->gettext('Gesamter aufwand im Ticket') %]</li>
        <li class="M2T"> [% $smarty.ldelim %]  DesireDate [% $smarty.rdelim %] => [% $user->gettext('Fälligkeitsdatum') %]</li>        

        <li> [% $smarty.ldelim %]  SupporterName [% $smarty.rdelim %] => [% $user->gettext('Name des Supporters') %]</li>
        <li> [% $smarty.ldelim %]  SupporterEMail [% $smarty.rdelim %] => [% $user->gettext('Mailadresse des Supporters') %]</li>
        <li> [% $smarty.ldelim %]  SupporterGroup [% $smarty.rdelim %] => [% $user->gettext('Gruppe des Tickets') %]</li>
        <li> [% $smarty.ldelim %]  ImportantContact [% $smarty.rdelim %] => [% $user->gettext('Kontakt mit Priorität') %]</li>

        <li class="M2T"> [% $smarty.ldelim %]  LastEvent [% $smarty.rdelim %] => [% $user->gettext('Letzte Bearbeitung') %]</li>
        <li> [% $smarty.ldelim %]  Ticketevents [% $smarty.rdelim %] => [% $user->gettext('Alle Ticketbearbeitungen (Array)') %]</li>

        <li class="M2T"> [% $smarty.ldelim %]  TicketURL [% $smarty.rdelim %] => [% $user->gettext('Link zum Ticket') %]</li>
        <li> [% $smarty.ldelim %]  TicketReference [% $smarty.rdelim %] => [% $user->gettext('Link zum Masterticket') %]</li>
    </ul>
    <h4>[% $user->gettext('Kontaktdaten') %]</h4>
    <ul>
        <li class="M2T"> [% $smarty.ldelim %]  ContactName [% $smarty.rdelim %] => [% $user->gettext('Kontakt') %]</li>
        <li> [% $smarty.ldelim %]  ContactCompany [% $smarty.rdelim %] => [% $user->gettext('Firmenname des Kontakts') %]</li>
        <li> [% $smarty.ldelim %]  ContactStreet [% $smarty.rdelim %] => [% $user->gettext('Straße') %]</li>
        <li> [% $smarty.ldelim %]  ContactZip [% $smarty.rdelim %] => [% $user->gettext('PLZ') %]</li>
        <li> [% $smarty.ldelim %]  ContactCity [% $smarty.rdelim %] => [% $user->gettext('Stadt') %]</li>
        <li> [% $smarty.ldelim %]  ContactPhone [% $smarty.rdelim %] => [% $user->gettext('Telefonnummer des Kontakts') %]</li>
        <li class="M2T"> [% $smarty.ldelim %]  ContactMail [% $smarty.rdelim %] => [% $user->gettext('Mailadresse des Kontakts') %]</li>
    </ul>

    <h4>[% $user->gettext('Bearbeiterdaten') %]</h4>
    <ul>
        <li> [% $smarty.ldelim %]  UserName [% $smarty.rdelim %] => [% $user->gettext('Name des Bearbeiters') %]</li>
        <li> [% $smarty.ldelim %]  UserMail [% $smarty.rdelim %] => [% $user->gettext('Mailadresse des Bearbeiters') %]</li>
        <li> [% $smarty.ldelim %]  UserCompany [% $smarty.rdelim %] => [% $user->gettext('Firma des Bearbeiters') %]</li>
        <li> [% $smarty.ldelim %]  UserStreet [% $smarty.rdelim %] => [% $user->gettext('Straße des Bearbeiters') %]</li>
        <li> [% $smarty.ldelim %]  UserZip [% $smarty.rdelim %] => [% $user->gettext('PLZ des Bearbeiters') %]</li>
        <li> [% $smarty.ldelim %]  UserCity [% $smarty.rdelim %] => [% $user->gettext('Stadt des Bearbeiters') %]</li>
        <li> [% $smarty.ldelim %]  UserPhone [% $smarty.rdelim %] => [% $user->gettext('Telefonnummer des Bearbeiters') %]</li>
    </ul>

    <h4>[% $user->gettext('Entscheiderkreis') %]</h4>
    <ul>
        <li> [% $smarty.ldelim %]  DecisionComment [% $smarty.rdelim %] => [% $user->gettext('Kommentar zur Entscheidung') %]</li>
    </ul>

    <h4>[% $user->gettext('Bearbeiterdaten') %]</h4>
    <ul>
        <li> [% $smarty.ldelim %]  ActivityTitle [% $smarty.rdelim %] => [% $user->gettext('Titel des Aktivitätstickets') %]</li>
        <li> [% $smarty.ldelim %]  WorkflowTitle [% $smarty.rdelim %] => [% $user->gettext('Titel der Workflowinstanz') %]</li>
        <li> [% $smarty.ldelim %]  FormData [% $smarty.rdelim %] => [% $user->gettext('Formulardaten der Aktivität') %]</li>
        <li> [% $smarty.ldelim %]  PrevFormData [% $smarty.rdelim %] => [% $user->gettext('Formulardaten der Vorgängeraktivitäten') %]</li>        
    </ul>    
    
</div>


<script>
    [% if $current_mailtype %]
    $('.tab-mailtype').hide();
    $('#tab-[% $current_mailtype %]').show();
    [% /if %]
    $(document).ready(function () {
        $(".dialog").fancybox({
            maxWidth: 800,
            maxHeight: 700,
            closeClick: false
        });
    });

</script>
