<script src="includes/js//jqueryui/1.12.1/jquery-ui.min.js"></script>
<style>
    .square {
        height: 15px;
        width: 15px;
    }
</style>

<script>
    
    var prevPagesOrder = [];
    var linksorder = [];
    $(function () {
        $("#sortable").sortable({
            start: function (event, ui) {
                prevPagesOrder = $(this).sortable('toArray');
            },
            update: function (event, ui) {
                var index = 1;
                $("#sortable").children().each(function () {
                    var currentElement = $(this);
                    // Show element
                    var ElementID = currentElement.attr('id');
                    var id = ElementID.split('_')[1];
                    linksorder.push({'pos': index, 'linkid': id});
                    index++;

                });
                $.post('index.php?module=settings&event=swapPosLink', {data: JSON.stringify(linksorder)}, function (data) {
                    index = 1;
                    linksorder = [];
                });
            }
        });
        $("#sortable").disableSelection();
    });
    function findCollapsedPanel(div) {
        var res = null;
        div.each(function () {
            //console.log($(this));
            if ($(this).hasClass('panel-collapse collapse')) {
                //console.log($(this));
                $(this).collapse("show");
                res = $(this);
            }
        });
        //console.log(res);
        return res;
    }
    $(document).ready(function () {
        OwnApplicationTicketTemplateChanged();
        $("#SearchInput").keyup(function (e) {

            if (e.keyCode == 13) {
                toggleSearch();
            }
        });

    });


    function toggleSearch() {
        var val = $("#SearchInput").val();
        if (val.trim() != "") {
            $(".control-label").css("background-color", "transparent");
            $(".panel-collapse").removeClass("in");
            var divs = $(".control-label:containsCI(" + val + ")").css("background-color", "yellow");
            var res = [];

            divs.each(function () {
                //console.log($(this));
                res.push(findCollapsedPanel($(this).parents()));
            });
        }
        if (res.length == 0) {
            noty({
                text: '[% $user->gettext("Keine Ergebnisse gefunden") %]',
                type: 'error',
                timeout: notifyTimeout
            });
        }
    }

    $.expr[":"].containsCI = $.expr.createPseudo(function (arg) {
        return function (elem) {
            return $(elem).text().toUpperCase().indexOf(arg.toUpperCase()) >= 0;
        };
    });

</script>
<div class = "card panel-fcs-border shadow-sm">

    <div class="card-header">
        <div class="row">
            <div class="col-lg-6">
                <h2 class="card-title-fcs">[% $user->gettext('Einstellungen') %]</h2>
            </div>
            <div class="col-lg-6 text-end">
            </div>
        </div>

    </div>
    <div class="card-body">

        <div class="input-group" style="margin-bottom:15px; max-width: 400px;">
            <input id="SearchInput" type="text" class="form-control" name="SearchInput" placeholder="[% $user->gettext('Suche nach einer Einstellung') %]">
            <span class="input-group-text" onclick="toggleSearch();"><span class="fa fa-search"></span></span>
            <span class="input-group-text" onclick="location.reload();" title="[% $user->gettext('Zurücksetzen') %]"><span class="fa fa-times"></span></span>
        </div>
        <div class="panel-group" id="SettingsAccordion" role="tablist" aria-multiselectable="true">
            <!--Datenbank-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingDatenbank">
                   
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Datenbank') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">

                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#DatenbankPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>

                            </div>
                        </div>
                    
                </div>
                <div id="DatenbankPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingDatenbank">
                    <div class="card-body">
                        [% if $ShowPW > 0%]
                            <div class="card panel-info shadow-sm rounded">
                                <div class="card-body">
                                    <p>[% $user->gettext('<b style="color:red;">Achtung: </b> Ab Heinzelmann 5.35 werden die Passwörter durch ein neues Hash-Verfahren in der DB gespeichert. Bitte testen Sie das neue Verfahren und aktualisieren Sie die Passwörter') %]</p>
                                    <div class="btn-group">
                                        <a href="index.php?module=settings&event=TestPassword" class="btn btn-outline-secondary openInLargeModal">[% $user->gettext('Neues Hash-Verfahren testen') %]</a>
                                        <a href="index.php?module=settings&event=UpdatePassword" class="btn btn-outline-secondary openInLargeModal">[% $user->gettext('Passwörter aktualisieren') %]</a>
                                    </div>
                                </div>
                            </div>
                        <br />
                        [% /if %]

                        <form action="index.php?module=settings&amp;event=DBSettings" method="post" name="hm" id="hm-Settings-DB" class="form-horizontal form-label-left" enctype="multipart/form-data" autocomplete="off">

                            <div class="row">
                                <div class="col-12">
                                    <div class="card panel-info shadow-sm rounded">
                                        <div class="card-body">
                                            <div class="btn-group">
                                                <input type="hidden" name="storeDBConnection" value="1" />
                                                <input type="reset" class="btn btn-outline-secondary"  value="[% $user->gettext('Reset') %]" />
                                                <input type="submit" class="btn btn-outline-primary"  value="[% $user->gettext('&Auml;nderungen speichern') %]" onclick="var check = confirm('[% $user->gettext('Wollen Sie die Datenbankeinstellungen wirklich &auml;ndern?') %]');
                                                        if (!check)
                                                            return false;" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card panel-info shadow-sm rounded">
                                        <div class="card-body">
                                            <div class = "mb-3 row">
                                                <label class = "col-lg-3 col-form-label" for="DBphptype">[% $user->gettext('Datenbanktyp') %]</label>
                                                <div class="col-lg-9">
                                                    <select class="form-control" size="1" name="DB[phptype]" id="DBphptype" >
                                                        [% foreach from=$DBLibs item=DBLibName key=DBLibKey %]
                                                            <option value="[% $DBLibKey %]" [% if $smarty.const.DBTYPE == $DBLibKey %]selected="selected"[% /if %]>[% $DBLibName %]</option>
                                                        [% /foreach %]
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label class = "col-lg-3 col-form-label" for="DBhostspec">[% $user->gettext('Datenbankhost') %]</label>
                                                <div class="col-lg-9">
                                                    <input type="text" name="DB[hostspec]" id="DBhostspec" class="form-control" value="[% $smarty.const.DBHOST %]" size="30" maxlength="255" />
                                                </div>
                                            </div>

                                            [% if $DB.phptype == 'oci8' %]
                                                <div class="mb-3 row">
                                                    <label class = " col-lg-3 col-form-label" for="DBserveraddress">[% $user->gettext('Serveradresse') %]</label>
                                                    <div class=" col-lg-9">
                                                        <input type="text" name="DB[serveraddress]" id="DBserveraddress" class="form-control" value="[% $smarty.const.DBADRESS %]" size="30" maxlength="255" />
                                                    </div>
                                                </div>
                                            [% /if %]

                                            <div class="mb-3 row">
                                                <label class = " col-lg-3 col-form-label" for="port">[% $user->gettext('Datenbankport') %]</label>
                                                <div class=" col-lg-9">
                                                    <input type="text" name="DB[port]" id="port" class="form-control" value="[% if $smarty.const.DBPORT > 0 %][% $smarty.const.DBPORT %][% /if %]" size="30" maxlength="255" />
                                                    <span class="help-block">[% $user->gettext('( Leer oder 0 ist gleich Standardport )') %]</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card panel-info shadow-sm rounded">
                                        <div class="card-body">

                                            <div class="mb-3 row">
                                                <label class = " col-lg-3 col-form-label" for="database">[% $user->gettext('Datenbank') %]</label>
                                                <div class=" col-lg-9">
                                                    <input type="text" name="DB[database]" id="database" class="form-control" value="[% $smarty.const.DBNAME %]" size="30" maxlength="255" />
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label class = " col-lg-3 col-form-label" for="username">[% $user->gettext('Datenbankbenutzer') %]</label>
                                                <div class=" col-lg-9">
                                                    <input type="text" name="DB[username]" id="username" class="form-control" value="[% $smarty.const.DBUSER %]" size="30" maxlength="255" />
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label class = " col-lg-3 col-form-label" for="DBpassword">[% $user->gettext('Datenbankpasswort') %]</label>
                                                <div class=" col-lg-9">
                                                    <input type="password" name="DB[password]" id="DBpassword" class="form-control" [% if $smarty.const.DBPASS %]value="*********"[% /if %] placeholder="[% $user->gettext('Passwort eingeben') %]" size="30" maxlength="255" autocomplete="off" />
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label class = " col-lg-3 col-form-label" for="DB[DB_USE_OLD_OLEDB]">[% $user->gettext('Alten MS-OLE-DB-Treiber verwenden') %]</label>
                                                <div class=" col-lg-9">
                                                    <input type="radio" name="DB[DB_USE_OLD_OLEDB]" value="1" [% if $smarty.const.DB_USE_OLD_OLEDB == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                                    <input type="radio" name="DB[DB_USE_OLD_OLEDB]" value="0" [% if $smarty.const.DB_USE_OLD_OLEDB != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                                                    <span class="help-block">[% $user->gettext('Wenn es im Heinzelmann-Dienst Verbindungsprobleme mit der Datenbank gibt, können Sie den älteren OLE-DB-Treiber verwenden (SQLOLEDB statt MSOLEDBSQL).') %]</span>
                                                </div>
                                            </div>


                                            <div class="mb-3 row">
                                                <label class = " col-lg-3 col-form-label" for="DB[assetdesk]">[% $user->gettext('Asset.Desk') %]</label>
                                                <div class=" col-lg-9">
                                                    <input type="radio" name="DB[assetdesk]" value="1" [% if $smarty.const.ASSETDESK == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                                    <input type="radio" name="DB[assetdesk]" value="0" [% if $smarty.const.ASSETDESK != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>

            <!--Benachrichtigungen-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingNotification">
                   
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Benachrichtigungen') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#NotificationPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>

                            </div>
                        </div>
                </div>
                <div id="NotificationPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingNotification">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/Notifications.tpl" %]
                    </div>
                </div>
            </div>

            <!--Mailversand-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingMailTemplates">
                    
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Mailtemplates') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#MailTemplatePanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>

                            </div>
                        </div>
                </div>
                <div id="MailTemplatePanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingMailTemplates">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/mail.tpl" %]
                    </div>
                </div>
            </div>

            <!--Allgemein-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingAllgemein">
                   
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Allgemein') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#AllgemeinPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>

                            </div>
                        </div>
                </div>
                <div id="AllgemeinPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingAllgemein">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/other.tpl" %]
                    </div>
                </div>
            </div>

            <!--Ticket-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingTicket">
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Ticket') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#TicketPanel" id="tabLink-TicketPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                    </a>
                </div>
                <div id="TicketPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTicket">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/ticket.tpl" %]
                    </div>
                </div>
            </div>

            <!--Rest-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingTicket">
                   
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Rest-API') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#RestPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="RestPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingRest">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/Rest.tpl" %]
                    </div>
                </div>
            </div>

            <!--Costs-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingCosts">
                    
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Kostenberechnung') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#CostsPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="CostsPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingCosts">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/Costs.tpl" %]
                    </div>
                </div>
            </div>


            <!--Escalation-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingEscalation">
                    
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Eskalation') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#EscalationPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="EscalationPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingEscalation">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/escalation.tpl" %]
                    </div>
                </div>
            </div>


            <!--Style-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingStyle">
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Optik') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#StylePanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="StylePanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingStyle">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/Style.tpl" %]
                    </div>
                </div>
            </div>

            <!--Auth-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingAuth">
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Authentifizierung') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#AuthPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="AuthPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingAuth">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/auth.tpl" %]
                    </div>
                </div>
            </div>


            <!--Mail2Ticket-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingMail2Ticket">
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('E-Mail in Ticket') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#Mail2TicketPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="Mail2TicketPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingMail2Ticket">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/mail2ticket.tpl" %]
                    </div>
                </div>
            </div>


            <!--Logs-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingLogs">
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Logs') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#LogsPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="LogsPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingLogs">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/LogDebug.tpl" %]
                    </div>
                </div>
            </div>

            <!--Dashboard-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingDashboard">
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Dashboard') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#DashboardPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>

                            </div>
                        </div>
                </div>
                <div id="DashboardPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingDashboard">
                    <div class="card-body">
                        <form action="index.php?module=settings&amp;event=dashbord#tab-dashboard" class="form-horizontal form-label-left" method="post" name="hm" id="hm-Settings-Dashboard" enctype="multipart/form-data" >
                            <div class="row">
                                <div class="col-md-6">
                                    <div>
                                        <div class="card panel-info shadow-sm rounded">
                                            <div class="card-header">
                                                [% $user->gettext('Eigene Anwendungen (Vorschaltseite)') %]
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group"  id="OwnApplicationList">
                                                    [% foreach from=$OnwApplications item=OnwApplication %]
                                                        <li class="list-group-item" id="OwnApplication_[% $OnwApplication->OwnApplicationID %]">
                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    [% $OnwApplication->title %]
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <label id="OwnApplicationDescription_[% $OnwApplication->OwnApplicationID %]">[% $OnwApplication->Description %]</label>
                                                                    <input class="form-control editLink" style="display:none;" type="text" id="OwnApplicationDescriptionEdit_[% $OnwApplication->OwnApplicationID %]" value="[% $OnwApplication->Description %]">
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <label id="OwnApplicationApplicationURL_[% $OnwApplication->OwnApplicationID %]">[% $OnwApplication->ApplicationURL %]</label>
                                                                    <input class="form-control editLink" style="display:none;" type="text" id="OwnApplicationApplicationURLEdit_[% $OnwApplication->OwnApplicationID %]" value="[% $OnwApplication->ApplicationURL %]">
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <a class="btn btn-outline-secondary" onclick="EditOwnApplication([% $OnwApplication->OwnApplicationID %]);" id="OwnApplicationEditButton_[% $OnwApplication->OwnApplicationID %]"><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>
                                                                    <input type="button" onclick="SubmitEditOwnApplication([% $OnwApplication->OwnApplicationID %]);" class="btn btn-outline-primary" style="display:none;" id="OwnApplicationSubmitEditButton_[% $OnwApplication->OwnApplicationID %]" value="[% $user->gettext('Updaten') %]">
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <a class="btn btn-outline-secondary" onclick="DeleteOwnApplication([% $OnwApplication->OwnApplicationID %]);"><span class="fa fa-trash" title="[% $user->gettext('Löschen') %]"></span></a>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    [% /foreach %]
                                                </ul>

                                                <hr/>
                                                <div class="card panel-info shadow-sm rounded">
                                                    <div class="card-header">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <h3 class="card-title">
                                                                    [% $user->gettext('Neue Anwendung') %]
                                                                </h3>
                                                            </div>
                                                            <div class="col-sm-6 text-end">
                                                                <div class="btn-group">
                                                                    <input type="button" onclick="SubmitOwnApplication();" class="btn btn-outline-primary" id="btnOwnApplications" value="[% $user->gettext('Speichern') %]">
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="card-body">
                                                        <input type="hidden" id="OwnApplicationID" value="0" />
                                                        <div class="mb-3 row">
                                                            <label class = "col-lg-3 col-form-label" for="OwnApplicationTicketTemplate">[% $user->gettext('Tickettemplate') %]</label>
                                                            <div class="col-lg-9">
                                                                <select class="form-control" name="OwnApplicationTicketTemplate" id="OwnApplicationTicketTemplate" onchange="OwnApplicationTicketTemplateChanged()" >
                                                                [% foreach from=$TicketTemplates item=TicketTemplate %]
                                                                    <option value="[% $TicketTemplate->TicketTemplateID %]">[% $TicketTemplate->title %]</option>
                                                                [% /foreach %]
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="mb-3 row">
                                                            <label class = "col-lg-3 col-form-label" for="OwnApplicationDescription">[% $user->gettext('Beschreibung') %]</label>
                                                            <div class="col-lg-9">
                                                                <input type="text" name="OwnApplicationDescription" id="OwnApplicationDescription" class="form-control" required="required" placeholder="[% $user->gettext('Beschreibung eingeben') %]" />
                                                            </div>
                                                        </div>

                                                        <div class="mb-3 row">
                                                            <label class = "col-lg-3 col-form-label" for="OwnApplicationURL">[% $user->gettext('URL') %]</label>
                                                            <div class="col-lg-9">
                                                                <input type="text" name="OwnApplicationURL" id="OwnApplicationURL" class="form-control" required="required" placeholder="http:// ... [% $user->gettext('URL eingeben') %]"/>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div>
                                        <div class="card panel-info shadow-sm rounded">
                                            <div class="card-header">
                                                <h3 class="card-title">[% $user->gettext('Linkliste') %]</h3>
                                            </div>
                                            <div class="card-body">

                                                <ul class="list-group"  id="sortable">
                                                    [% foreach from=$LinkList item=Link %]
                                                        <li class="list-group-item" id="Link_[% $Link.linkid %]" [% if !$Link.active %]class="unactive"[% /if %]>
                                                            <div class="row">
                                                                <div class="col-md-9">
                                                                    [% if $Link.imagepath %]
                                                                        <a href="[% $Link.url %]" target="_blank" title="[% $Link.descr %]" id="Link_Text_[% $Link.position %]" ><img style="max-width: 75px;" src="[% $Link.imagepath %]" /></a>
                                                                        [% else %]
                                                                        <a href="[% $Link.url %]" id="Link_Text_[% $Link.position %]" target="_blank" >[% $Link.descr %]</a>
                                                                    [% /if %]
                                                                    <input class="form-control editLink" style="display:none;" type="text" id="Link_Edit_[% $Link.position %]" value="[% $Link.descr %]">
                                                                    <input class="form-control editLink" style="display:none;" type="text" id="Link_URL_[% $Link.position %]" value="[% $Link.url %]">
                                                                    <input type="file" id="Link_IMG_[% $Link.position %]" class="form-control" style="display:none" />
                                                                    <input type="button" onclick="submitEditLink([% $Link.position %]);" class="btn btn-outline-primary" style="display:none;" type="button" id="Link_EditBtn_[% $Link.position %]" value="[% $user->gettext('Updaten') %]">

                                                                </div>
                                                                <div class="col-md-1">
                                                                    <input type="checkbox" id="Link_[% $Link.position %]_Checkbox" onclick="toggleLink(this, [% $Link.position %]);" [% if $Link.active %]checked="checked" title="[% $user->gettext('Link für unangemeldete Benutzer zusätzlich anzeigen?') %]"[% else %]title="[% $user->gettext('Link für unangemeldete Benutzer zusätzlich anzeigen?') %]"[% /if %]  />
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <a class="btn btn-outline-secondary" onclick="editLink([% $Link.position %]);"><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>
                                                                </div>
                                                                <div class="col-md-1">
                                                                    <a class="btn btn-outline-secondary" onclick="deleteLink([% $Link.linkid %]);"><span class="fa fa-trash" title="[% $user->gettext('Löschen') %]"></span></a>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    [% /foreach %]
                                                </ul>

                                                <hr/>
                                                <div class="card panel-info shadow-sm rounded">
                                                    <div class="card-header">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <h3 class="card-title">
                                                                    [% $user->gettext('Neuer Link') %]
                                                                </h3>
                                                            </div>
                                                            <div class="col-sm-6 text-end">
                                                                <div class="btn-group">
                                                                    <input type="button" onclick="SubmitNewLink();" class="btn btn-outline-secondary" value="[% $user->gettext('Speichern') %]" />
                                                                    <input type="reset" class="btn btn-outline-secondary" value="[% $user->gettext('Reset') %]" />
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="card-body">

                                                        <div class="mb-3 row">
                                                            <label class = "col-lg-3 col-form-label" for="NewLink">[% $user->gettext('URL') %]</label>
                                                            <div class="col-lg-9">
                                                                <input type="url" name="NewLink" id="NewLink" class="form-control" required="required" placeholder="http:// ... [% $user->gettext('URL eingeben') %]" />
                                                            </div>
                                                        </div>

                                                        <div class="mb-3 row">
                                                            <label class = "col-lg-3 col-form-label" for="NewDescr">[% $user->gettext('Beschreibung') %]</label>
                                                            <div class="col-lg-9">
                                                                <input type="text" name="NewDescr" id="NewDescr" class="form-control"  required="required" placeholder="[% $user->gettext('Beschreibung eingeben') %]" />
                                                            </div>
                                                        </div>

                                                        <div class="mb-3 row">
                                                            <label class = "col-lg-3 col-form-label" for="NewImage">[% $user->gettext('Datei ausw&auml;hlen') %]</label>
                                                            <div class="col-lg-9">
                                                                <input type="file" name="NewImage" id="NewImage" class="form-control"  />
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            [% if $user->Security->Company == 'BHS BAD HOMBURGER SERVICEGESELLSCHAFT' || $user->Security->Company == 'Fair Computer Systems GmbH' %]
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header" role="tab" id="headingAnonymisieren">
                            <div class="row">
                                <div class="col-4">
                                    <h4 class="card-title">
                                        [% $user->gettext('Tickets anonymisieren') %]
                                    </h4>
                                </div>
                                <div class="col-8 text-end">
                                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#AnonymisierenPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                                </div>
                            </div>
                    </div>
                    <div id="AnonymisierenPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingAnonymisieren">
                        <div class="card-body">
                            [% include file=$modulePath|cat:"/Anonymisieren.tpl" %]
                        </div>
                    </div>
                </div>
            [% /if %]                    

            [%*
            <!--BOT-->
            <div class="card panel-info shadow-sm rounded">
            <div class="card-header" role="tab" id="headingBot">
            <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#BotPanel" aria-expanded="false" aria-controls="collapseContact">
            <div class="row">
            <div class="col-4">
            <h4 class="card-title">
            [% $user->gettext('HEINZELMANN-Bot') %]
            </h4>
            </div>
            <div class="col-8">

            </div>
            </div>
            </a>
            </div>
            <div id="BotPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingBot">
            <div class="card-body">
            [% include file=$modulePath|cat:"/bot.tpl" %]
            </div>
            </div>
            </div>
            *%]                    
            <!--About-->
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header" role="tab" id="headingAbout">
                        <div class="row">
                            <div class="col-4">
                                <h4 class="card-title">
                                    [% $user->gettext('Über HEINZELMANN') %]
                                </h4>
                            </div>
                            <div class="col-8 text-end">
                                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVESettingsAccordion" href="#AboutPanel" aria-expanded="false" aria-controls="collapseContact"><span class="fa fa-chevron-down"></span></a>
                            </div>
                        </div>
                </div>
                <div id="AboutPanel" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingAbout">
                    <div class="card-body">
                        [% include file=$modulePath|cat:"/about.tpl" %]
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>


<script>
    $('.select2').select2({theme: 'bootstrap-5'});
    $('.multiple2').select2({theme: 'bootstrap-5'});

    $("#sendTestmail").on('click', function (e) {
        $("#MailtestResult").load('index.php?module=settings&event=sendTestmail&recipient=' + $("#TestmailRecipient").val());
    });


    $(document).ready(function () {
        if (location.hash != null && location.hash != "") {
//        $('.collapse').removeClass('in');
            $(location.hash + '.collapse').collapse('show');
        }
    });

</script>

<script type="text/javascript">

    $(document).ready(function () {
        $("#tabs").tabs();

    [% if $tab %]
        showTab('[% $tab %]');
    [% /if %]

        function showTab(Tab) {
            $('#tabLink-' + Tab).trigger("click");
        }

        $(".dialog").fancybox({
            maxWidth: 600,
            maxHeight: 520,
            autoSize: true,
            closeClick: false
        });
        $(".dialog_big").fancybox({
            maxWidth: 700,
            maxHeight: 550,
            autoSize: true,
            closeClick: false
        });
        $(".dialog_medium").fancybox({
            maxWidth: 650,
            maxHeight: 350,
            autoSize: true,
            closeClick: false
        });


        $(".multiple").multiselect({
            buttonClass: 'form-select',
    templates: {
        button: '<button type="button" class="multiselect dropdown-toggle" data-bs-toggle="dropdown"><span class="multiselect-selected-text"></span></button>',
    },
            checkAllText: '[% $user->gettext("Alle") %]',
            uncheckAllText: '[% $user->gettext("Keine") %]',
            noneSelectedText: '[% $user->gettext("Wählen Sie") %]',
            selectedList: 1,
            selectedText: false,
            header: true,
            multiple: false
        });

//Notifications.tpl
        if ($("input[name='Notifications[MailActive]']:checked").val() == 1)
            $('.mail-content').show();
        else
            $('.mail-content').hide();

        if ($("input[name='Notifications[TeamsActive]']:checked").val() == 1)
            $('.teams-content').show();
        else
            $('.teams-content').hide();

        if ($("input[name='Notifications[Mail_SMTPAuth]']:checked").val() == 1)
            $('.smtp-content').show();
        else
            $('.smtp-content').hide();

        $("input[name='Notifications[MailActive]']").on("change", function () {
            if ($("input[name='Notifications[MailActive]']:checked").val() == 1)
                $('.mail-content').show();
            else
                $('.mail-content').hide();
        });

        $("input[name='Notifications[TeamsActive]']").on("change", function () {
            if ($("input[name='Notifications[TeamsActive]']:checked").val() == 1)
                $('.teams-content').show();
            else
                $('.teams-content').hide();
        });

        $("input[name='Notifications[Mail_SMTPAuth]']").on("change", function () {
            if ($("input[name='Notifications[Mail_SMTPAuth]']:checked").val() == 1)
                $('.smtp-content').show();
            else
                $('.smtp-content').hide();
        });


        showOrHideSupporterCreateMailOptions($('input[name="Notifications[NotifySupportCreateActive]"]:checked', '#hm-Settings-Notifications').val());
        showOrHideSupporterEditMailOptions($('input[name="Notifications[NotifySupportEditActive]"]:checked', '#hm-Settings-Notifications').val());

    })

    $('input[name="Notifications[NotifySupportCreateActive]"]:radio').on("change", function () {
        showOrHideSupporterCreateMailOptions($('input[name="Notifications[NotifySupportCreateActive]"]:checked', '#hm-Settings-Notifications').val());
    })

    function showOrHideSupporterCreateMailOptions(isActive) {
        if (isActive == 1) {
            $('.supportercreatnotification-content').show();
        } else {
            $('.supportercreatnotification-content').hide();
        }
    }
    $('input[name="Notifications[NotifySupportEditActive]"]:radio').on("change", function () {
        showOrHideSupporterEditMailOptions($('input[name="Notifications[NotifySupportEditActive]"]:checked', '#hm-Settings-Notifications').val());
    })

    function showOrHideSupporterEditMailOptions(isActive) {
        if (isActive == 1) {
            $('.supportereditnotification-content').show();
        } else {
            $('.supportereditnotification-content').hide();
        }
    }
//Costs

    function SuggestKat1() {
        var Cat1Auswahl = document.getElementById('CostRateSourceCat1').checked ? true : false;
        if (Cat1Auswahl && confirm(msgAskCat1Required)) {
            makeHttpRequest('index.php?module=settings&event=setCat1Req', 'showMessage', true);
        } else {
            $('#hm-Settings-Costs').submit();
        }
    }

    function showMessage() {
        alert(msgCat1ChangedtoRequired);
        $('#hm-Settings-Costs').submit();
    }

    function deleteLink(linkid)
    {
        if (confirm('Möchten Sie diesen Link wirklich löschen?'))
        {
            $.get("index.php?module=settings&event=deleteLink&linkid=" + linkid, function (data)
            {
                if (parseInt(data) === 1)
                {
                    $("#Link_" + linkid).hide();
                }
            });
        }
    }

    function editLink(LinkPosition) {

        if (!$('#Link_Edit_' + LinkPosition).is(':visible')) {
            $('#Link_Edit_' + LinkPosition).css("display", "block");
            $('#Link_EditBtn_' + LinkPosition).css("display", "block");
            $('#Link_Text_' + LinkPosition).css("display", "none");
            $('#Link_URL_' + LinkPosition).css("display", "block");
            $('#Link_IMG_' + LinkPosition).css("display", "block");
        } else {
            $('#Link_Edit_' + LinkPosition).css("display", "none");
            $('#Link_EditBtn_' + LinkPosition).css("display", "none");
            $('#Link_Text_' + LinkPosition).css("display", "block");
            $('#Link_URL_' + LinkPosition).css("display", "none");
            $('#Link_IMG_' + LinkPosition).css("display", "none");

        }

    }

    function submitEditLink(LinkPosition) {
        var fd = new FormData();
        var files = $('#Link_IMG_' + LinkPosition)[0].files[0];
        fd.append('NewImage', files);
        fd.append('pos', LinkPosition);
        fd.append('descr', $('#Link_Edit_' + LinkPosition).val());
        fd.append('url', $('#Link_URL_' + LinkPosition).val());
        $.ajax({
            url: 'index.php?module=settings&event=updateLink',
            type: 'post',
            data: fd,
            contentType: false,
            processData: false,
            success: function (data) {
                if (parseInt(data) == 1) {
                    alert('Link wurde geändert');
                    //alert('file uploaded');
                    location.reload();
                } else {
                    //alert('file not uploaded');
                }
            },
        });

    }

    $(".editLink").on('keyup', function (e) {
        if (e.keyCode == 13) {
            console.log($(this).val());
        }
    });

    function toggleLink(e, LinkPosition) {



        var toggle = 0;
        if ($(e).is(':checked')) {
            toggle = 1;
        }

        $.get("index.php?module=settings&event=toggleLink&position=" + LinkPosition + "&set=" + toggle, function (data) {
            if (parseInt(data) === 1) {
                $(e).prop('checked', toggle);
                if (toggle === 0) {
                    $("#Link_" + LinkPosition).hide().addClass("unactive").show();
                    $("#Link_" + LinkPosition + "_Checkbox").attr('title', 'Link anzeigen');
                } else {
                    $("#Link_" + LinkPosition).hide().removeClass("unactive").show();
                    $("#Link_" + LinkPosition + "_Checkbox").attr('title', 'Link verbergen');
                }
            }
        });
    }


    var SupporterSelectID = '';

    var $groupSelect = $("#DefaultTicketGroupIDs").select2({theme: 'bootstrap-5',
        //placeholder: "[% $user->gettext("Gruppe wählen") %]",
//  closeOnSelect: false,
        language: "[% $user->language_type %]"
    }).on("change", function (e) {
        SupporterSelectID = 'DefaultTicketSupporterIDs';
        showSupporter(this);
    });


    var $supporterSelect = $("#DefaultTicketSupporterIDs, #Mail2TicketDefSupporter").select2({theme: 'bootstrap-5',
        //placeholder: "[% $user->gettext("Supporter wählen") %]",
//  closeOnSelect: false,
        language: "[% $user->language_type %]"
    });

    var $m2tgroupSelect = $("#Mail2TicketDefGroup").select2({theme: 'bootstrap-5',
        //placeholder: "[% $user->gettext("Gruppe wählen") %]",
//  closeOnSelect: false,
        language: "[% $user->language_type %]",
        allowClear: true
    }).on("change", function (e) {
        SupporterSelectID = 'Mail2TicketDefSupporter';
        showSupporter(this);
    });

    function showSupporter(el)
    {
        var GroupIDs = $(el).val();
        makeHttpRequest("index.php?module=user&event=AJAXSupporterList&withNoOne=1&gid=" + GroupIDs, "buildSupporterList", true);
    }


    function buildSupporterList(xmldoc)
    {
        FieldID = 'DefaultTicketSupporterIDs';
        if ('' !== SupporterSelectID) {
            FieldID = SupporterSelectID;
        }

        var el = document.getElementById(FieldID);
        if (el) {
            //var UserID = el.options[el.options.selectedIndex].value;
            var UserID = [];
            UserID = $('#' + FieldID).val();
            el.length = 0;
            var users = xmldoc.getElementsByTagName("user");
            if (users.length > 0) {
                for (i = 0; i < users.length; i += 1) {
                    //if (users[i].getAttribute('id') == UserID) {
                    if (UserID !== null && UserID.indexOf(users[i].getAttribute('id')) >= 0) {
                        NewEntry = new Option(users[i].getAttribute('name'), users[i].getAttribute('id'), false, true);
                    } else {
                        NewEntry = new Option(users[i].getAttribute('name'), users[i].getAttribute('id'), false, false);
                    }
                    el.options[el.length] = NewEntry;
                }
            }
            $supporterSelect.trigger('change');
        }
    }


    $('#ReplyMailTemplateID').select2({theme: 'bootstrap-5'});
    function testConnection() {
        $.post('index.php?module=settings&event=testCouchConnection', {host: $('#CouchHost').val(), port: $('#CouchPort').val(), db: $('#CouchDBName').val(), admin: $('#CouchAdmin').val(), password: $('#CouchPassword').val()},
                function (data) {
                    console.log(data);
                    dataObj = JSON.parse(data);
                    console.log(data);
                    if (dataObj.code == 0) {
                        noty({
                            text: dataObj.text,
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    }
                    if (dataObj.code == 1) {
                        noty({
                            text: dataObj.text,
                            type: 'success',
                            timeout: notifyTimeout
                        });
                    }
                })
    }

    /**
     * back up CouchDB data
     */
    function backupCouchDBData() {
        $.post('index.php?module=settings&event=backupCouchDB', {host: $('#CouchHost').val(), port: $('#CouchPort').val(), db: $('#CouchDBName').val(), admin: $('#CouchAdmin').val(), password: $('#CouchPassword').val()},
                function (data) {
                    console.log(data);

                    dataObj = JSON.parse(data);
                    console.log(data);
                    if (dataObj.code == 0) {
                        noty({
                            text: dataObj.text,
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    }
                    if (dataObj.code == 1) {
                        noty({
                            text: dataObj.text,
                            type: 'success',
                            timeout: notifyTimeout
                        });
                    }
                })
    }

    $('#ActivateDeleteTickets').on('change', function (e) {
        if ($(this).is(':checked')) {
            bootbox.confirm("[% $user->gettext('ACHTUNG! Wenn Sie diese Änderung speichern, werden ab sofort alle Tickets die vor dem angegebenem Zeitraum erstellt wurden gelöscht.') %]", function (result) {
                if (result) {
                } else {
                    $('#ActivateDeleteTickets').prop("checked", false);
                }
            })
        }
    })

    $('input[type=radio][name="Other[GroupUploadDir]"]').on('change', function () {

        bootbox.confirm("[% $user->gettext('Soll die Datenstruktur im Uploadverzeichnis jetzt angepasst werden?') %]", function (result) {
            if (result) {
    [% if $smarty.const.GROUPUPLOADDIR == 1 %]
                jsonMoveDocuments(1);
    [% else %]
                jsonMoveDocuments(0);
    [% /if %]
            }
        })
    })

    function SubmitNewLink()
    {
        var fd = new FormData();
        var files = $('#NewImage')[0].files[0];
        fd.append('NewImage', files);
        fd.append('NewDescr', $('#NewDescr').val());
        fd.append('NewLink', $('#NewLink').val());
        $.ajax({
            url: 'index.php?module=settings&event=dashbord',
            type: 'post',
            data: fd,
            contentType: false,
            processData: false,
            success: function (data) {
                if (parseInt(data) == 1) {
                    alert('Neuer Link wurde gespeichert');
                    //alert('file uploaded');
                    location.reload();
                } else {
                    //alert('Neuer Link wurde nicht gespeichert');
                }
            },
        });
    }

    function SubmitOwnApplication()
    {
        $.post('index.php?module=settings&class=OwnApplication&event=SaveOwnApplication', {OwnApplicationID: $('#OwnApplicationID').val(), TicketTemplateID: $('#OwnApplicationTicketTemplate').val(), Description: $('#OwnApplicationDescription').val(), ApplicationURL: $('#OwnApplicationURL').val()}, function (data)
        {
            message = "Fehler beim Speichern der eigenen Anwednung.";
            type = "error";
            if(data > 0)
            {
                message = "Eigene Anwednung gespeichert.";
                type = "success";
                AddOwnApplicationToList(data, $( "#OwnApplicationTicketTemplate option:selected" ).text(), $('#OwnApplicationDescription').val(), $('#OwnApplicationURL').val());
                OwnApplicationTicketTemplateChanged();
            }

             noty({
                    text: message,
                    type: type,
                    timeout: notifyTimeout
                });
        });
    }

    function AddOwnApplicationToList(OwnApplicationID, title, Description, ApplicationURL)
    {
        listitem = '<li class="list-group-item" id="OwnApplication_' + OwnApplicationID + '">' +
            '<div class="row">' +
                '<div class="col-md-3">' +
                   title +
                '</div>' +
                '<div class="col-md-4">' +
                    '<label id="OwnApplicationDescription_' + OwnApplicationID + '">' + Description + '</label>' +
                    '<input class="form-control editLink" style="display:none;" type="text" id="OwnApplicationDescriptionEdit_' + OwnApplicationID + '" value="' + Description + '">' +
                '</div>' +
                '<div class="col-md-3">' +
                    '<label id="OwnApplicationApplicationURL_' + OwnApplicationID + '">' + ApplicationURL + '</label>' +
                    '<input class="form-control editLink" style="display:none;" type="text" id="OwnApplicationApplicationURLEdit_' + OwnApplicationID + '" value="' + ApplicationURL +'">' +
                '</div>' +
                '<div class="col-md-1">' +
                    '<a class="btn btn-outline-secondary" onclick="EditOwnApplication(' + OwnApplicationID + ');" id="OwnApplicationEditButton_' + OwnApplicationID + '"><span class="fa fa-pencil" title="[% $user->gettext("Bearbeiten") %]"></span></a>' +
                    '<input type="button" onclick="SubmitEditOwnApplication(' + OwnApplicationID + ');" class="btn btn-outline-primary" style="display:none;" id="OwnApplicationSubmitEditButton_' + OwnApplicationID + '" value="[% $user->gettext("Updaten") %]">' +
                '</div>' +
                '<div class="col-md-1">' +
                    '<a class="btn btn-outline-secondary" onclick="DeleteOwnApplication(' + OwnApplicationID + ');"><span class="fa fa-trash" title="[% $user->gettext("Löschen") %]"></span></a>' +
                '</div>' +
            '</div>' +
        '</li>';
        $("#OwnApplicationList").append(listitem);
    }

    function SubmitEditOwnApplication(OwnApplicationID)
    {
        $.post('index.php?module=settings&class=OwnApplication&event=SaveOwnApplication', {OwnApplicationID: OwnApplicationID, Description: $('#OwnApplicationDescriptionEdit_' + OwnApplicationID).val(), ApplicationURL: $('#OwnApplicationApplicationURLEdit_' + OwnApplicationID).val()}, function (data)
        {
            message = "Fehler beim Speichern der eigenen Anwednung.";
            type = "error";

            if(data > 0)
            {
                message = "Eigene Anwednung gespeichert.";
                type = "success";
                $('#OwnApplicationDescription_' + OwnApplicationID).text ($('#OwnApplicationDescriptionEdit_' + OwnApplicationID).val());
                $('#OwnApplicationApplicationURL_' + OwnApplicationID).text ($('#OwnApplicationApplicationURLEdit_' + OwnApplicationID).val());
                EditOwnApplication(OwnApplicationID);
            }

             noty({
                    text: message,
                    type: type,
                    timeout: notifyTimeout
                });
        });
    }
    
    function DeleteOwnApplication(OwnApplicationID)
    {
        if (confirm('Möchten Sie diesen Link wirklich löschen?'))
        {
            $.get("index.php?module=settings&class=OwnApplication&event=DeleteOwnApplication&OwnApplicationID=" + OwnApplicationID, function (data)
            {
                if (parseInt(data) === 1)
                {
                    $("#OwnApplication_" + OwnApplicationID).hide();
                    OwnApplicationTicketTemplateChanged();
                }
            });
        }
    }

    function EditOwnApplication(OwnApplicationID)
    {
        if (!$('#OwnApplicationSubmitEditButton_' + OwnApplicationID).is(':visible'))
        {
            $('#OwnApplicationEditButton_' + OwnApplicationID).css("display", "none");
            $('#OwnApplicationSubmitEditButton_' + OwnApplicationID).css("display", "block");
            $('#OwnApplicationDescription_' + OwnApplicationID).css("display", "none");
            $('#OwnApplicationDescriptionEdit_' + OwnApplicationID).css("display", "block");
            $('#OwnApplicationApplicationURL_' + OwnApplicationID).css("display", "none");
            $('#OwnApplicationApplicationURLEdit_' + OwnApplicationID).css("display", "block");
        } else {
            $('#OwnApplicationEditButton_' + OwnApplicationID).css("display", "block");
            $('#OwnApplicationSubmitEditButton_' + OwnApplicationID).css("display", "none");
            $('#OwnApplicationDescription_' + OwnApplicationID).css("display", "block");
            $('#OwnApplicationDescriptionEdit_' + OwnApplicationID).css("display", "none");
            $('#OwnApplicationApplicationURL_' + OwnApplicationID).css("display", "block");
            $('#OwnApplicationApplicationURLEdit_' + OwnApplicationID).css("display", "none");
        }
    }

    function OwnApplicationTicketTemplateChanged()
    {
        $.get("index.php?module=settings&class=OwnApplication&event=CheckIfOwnApplicationAlreadyExists&TicketTemplateID=" + $('#OwnApplicationTicketTemplate').val(), function (data) {
            if(data == 1)
            {
                $('#btnOwnApplications').prop('disabled', true);
                $('#btnOwnApplications').prop('title', 'Für dieses Template existiert bereits eine eigene Anwendung.');
            }
            else
            {
                $('#btnOwnApplications').prop('disabled', false);
                $('#btnOwnApplications').prop('title', '');
            }
        });
    }

    var countSteps = 0;
    function jsonMoveDocuments(undo) {
        $('#progressDocuments').show();
        $.post('index.php?module=upload&event=jsonMoveDocuments', {save: 1, count: countSteps, undo: undo}, function (data) {
            if (!data.error) {

                if (countSteps < 100) {
                    countSteps++;
                    $("#progressBarDocuments").width((countSteps + 1) * 100 / 100 + '%');
                    jsonMoveDocuments(data.undo);
                } else {
                    $('#hm-Settings-Other').submit();
                }
            }
        });
    }


    $("#DefContact, #Mail2TicketDefContact").select2({theme: 'bootstrap-5',
        minimumInputLength: 1,
        ajax: {
            url: "index.php?module=contact&event=getJsonContacts",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data) {
                return {
                    results: data.items
                };
            }
        },
        escapeMarkup: function (markup) {
            return markup;
        }
    });

// -->
</script>
