<link rel="stylesheet" href="includes/js/bootstrap-select-1.12.4/dist/css/bootstrap-select.min.css">
<!-- Latest compiled and minified JavaScript -->
<script src="includes/js/bootstrap-select-1.12.4/dist/js/bootstrap-select.min.js"></script>

<!-- (Optional) Latest compiled and minified JavaScript translation files -->
<script src="includes/js/bootstrap-select-1.12.4/dist/js/i18n/defaults-[% if $user->language_type == "de" %]de_DE[% else %]en_US[% /if %].min.js"></script>
<div class="modal" id="fieldModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #f5f5f5">
                <div class="row">
                    <div class="col-sm-6">
                        <h3 class="modal-title">[% $user->gettext('Feld erstellen') %]</h3>
                        <span><i>[% $user->gettext('Das Feld bleibt erhalten, auch wenn der Tickettyp gelöscht wird') %]</i></span>
                    </div>
                    <div class="col-sm-6 text-end">
                        <div class="btn-group">
                            <button type="button" class="btn btn-outline-primary" onclick="saveField();">[% $user->gettext('Speichern') %]</button>
                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">[% $user->gettext('Abbrechen') %]</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-body">
                <div class="form-horizontal form-label-left">
                    <div class="form-group row mb-3">
                        <label class="col-sm-3 control-label">
                            [% $user->gettext('Feldname') %]: &nbsp; &nbsp;
                        </label>
                        <div class="col-sm-9">
                            <input type="text" required="required" id="fieldName" class="form-control">
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-sm-3 control-label">
                            [% $user->gettext('Kommentar') %]: &nbsp; &nbsp;
                        </label>
                        <div class="col-sm-9">
                            <input type="text" required="required" id="fieldComment" class="form-control" placeholder="[% $user->gettext('Empfohlen, um das Feld zu identifizieren') %]">
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-sm-3 control-label">
                            [% $user->gettext('Feldtyp') %]: &nbsp; &nbsp;
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" id="field_select_type" onchange="selectForm()">
                                <option value="0">[% $user->gettext('Feldtyp auswählen') %]</option>
                                <option value="text">[% $user->gettext('Textfeld') %]</option>
                                <option value="textarea">[% $user->gettext('Textbereich') %]</option>
                                <option value="checkbox">[% $user->gettext('Checkbox') %]</option>
                            </select>
                        </div>
                    </div>
                    <div id="fieldDiv">

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

<form action="[% if !$original_type %]index.php?module=tickettype&event=update&saveType=1&id=[% $type.type_id %][% else %]index.php?module=tickettype&event=create&saveType=1[% /if %]" method="post" id="hm1" class="form-inline" enctype="multipart/form-data">
    <input type="hidden" name="saveType" value="1">
    <input type="hidden" name="fields" id="fields" value="">
    <input type="hidden" name="defFields" id="defFields" value="">
    <input type="hidden" name="deactive" id="deactive" value="[% if $type.active == 0 %]1[% else %]0[% /if %]">
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    [% if !$original_type %] <span class="fcs-card-title h1">[% $user->gettext('Tickettyp aktualisieren') %]: [% $type.type_name %][% if $type.type_id == $smarty.const.STANDARDTICKETTYPE %] (Standard Tickettyp)[% /if%]</span>
                    [% else %] <span class="fcs-card-title h1">[% $user->gettext('Tickettyp erstellen') %]</span><h4>[% $user->gettext('Aus Vorlage') %]:<strong>[% $type.type_name %]</strong></h4>
                        [% /if %]
                        [% if $onlyshow && !$original_type %]<p style="color:red;">[% $user->gettext('Der Tickettyp wird in Tickets verwendet. Sie können nur den Namen oder das Icon anpassen.') %]</p>[% /if %]
                </div>
                <div class="col-sm-6 text-end">
                    <input type="button" value="[% $user->gettext('Speichern') %]" onclick="checkForm();" class="btn btn-outline-primary">
                    <a   href="index.php?module=tickettype" class="btn btn-outline-primary">[% $user->gettext('Liste') %]</a>
                    [% if  $type.type_id != $smarty.const.STANDARDTICKETTYPE %]
                        [% if $type.active != 0 &&  !$original_type  %]
                            <input type="button" value="[% $user->gettext('Deaktivieren') %]" onclick="activeType(1);" class="btn btn-outline-primary">
                        [% else if !$original_type %]
                            <input type="button" value="[% $user->gettext('Aktivieren') %]" onclick="activeType(0);" class="btn btn-outline-primary">
                        [% /if %]
                    [% /if %]
                </div>
            </div>
        </div>
        <script>
            function activeType(act) {
                change_active = false;
                var mess = "";
                if (act == 0) {
                    mess = '[% $user->gettext("Tickettyp wirklich aktivieren?") %]';
                } else {
                    mess = '[% $user->gettext("Tickettyp wirklich deaktivieren?") %]';
                }
                bootbox.confirm(mess, function (result) {
                    if (result) {
                        $('#deactive').val(act);
                        checkForm();
                    }
                })
            }
        </script>

        <div class="card-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-body">
                            <div class="form-group row mb-3" style="margin-left:20px;">
                                <label class="control-label">
                                    [% $user->gettext('Name') %]:
                                </label>
                                <input type="text" name="name" value="[% $type.type_name %][% if $original_type %] 1[% /if %]" id="name" class="form-control" required >
                            </div>
                            <div class="form-group row mb-3" style="margin-left:20px;">
                                <label class="control-label">
                                    [% $user->gettext('Icon') %]:
                                </label>
                                <select name="TypeIcon" style="min-width:100px;" id="icon" class="form-control">
                                    <option value="0">Keine</option>
                                </select>
                            </div>
                            [% if $original_type %]
                                <div class="form-group row mb-3" style="margin-left:20px;">
                                    <label class="control-label">
                                        [% $user->gettext('Vorlage') %]:
                                    </label>
                                    <select name="TypeTemplate"  id="TypeTemplate" class="form-control">
                                        <option value="0">Standard Ticket</option>
                                        [% foreach from=$types item=$t %]
                                            <option value="[% $t.type_id %]" [% if $t.type_id == $original_type %]selected[% /if %]>[% $t.type_name %]</option>
                                        [% /foreach %]
                                    </select>
                                </div>
                            [% /if %]
                            [% if $type.type_id != $smarty.const.STANDARDTICKETTYPE %]
                                <div class="form-group row mb-3" style="margin-left:20px;">
                                    <label class="control-label">
                                        [% $user->gettext('Freigeben für') %]:
                                    </label>
                                    <select size="1" name="CreateGroupIDs[]" id="CreateGroupIDs"  data-actions-box="true" data-title="[% $user->gettext("Gruppe wählen") %]" class="selectpicker" data-live-search="true" data-selected-text-format="count>0"
                                            data-count-selected-text= "[%$user->gettext('Gruppen') %] ({0} [%$user->gettext('gewählt') %])"  title="[% $user->gettext('Gruppe') %] 1" multiple>
                                        [% foreach from=$groups item=$group %]
                                            <option value="[% $group.group_id %]" [% if $Tools->FCS_InArray($group.group_id, $create_groups) %]selected="selected"[% /if %]>[% $group.name %]</option>
                                        [% /foreach %]
                                    </select>
                                </div>
                            [% /if %]                           

                            <div class="form-group row mb-3" style="margin-left:20px; ">
                                <label class="control-label" title="[% $user->gettext('Gruppen, welche benachrichtigt werden, wenn ein Ticket in diesen Typ wechselt') %]">
                                    [% $user->gettext('Benachrichtigung') %]
                                </label>
                                <select size="1" name="NotyGroupIDs[]" data-actions-box="true" id="NotyGroupIDs" data-title="[% $user->gettext("Gruppe wählen") %]" class="selectpicker" data-live-search="true" data-selected-text-format="count>0"
                                        data-count-selected-text= "[% $user->gettext('Gruppen') %] ({0} [% $user->gettext('gewählt') %])"  title="[% $user->gettext('Gruppe') %] 1" multiple>
                                    [% foreach from=$groups item=$group %]
                                        <option value="[% $group.group_id %]" [% if $Tools->FCS_InArray($group.group_id, $NotyGroups) %]selected="selected"[% /if %]>[% $group.name %]</option>
                                    [% /foreach %]
                                </select>
                            </div>
                            

                            [% if $original_type %]
                                <div class="form-group row mb-3" style="margin-left:20px;">
                                    <label class="control-label">
                                        [% $user->gettext('Aktiv?') %]
                                    </label>
                                    <input name="type_active" type='checkbox' checked='checked'>
                                </div>
                            [% /if %]

                        </div>
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <span class="fcs-card-title h4">
                                [% $user->gettext(' Standard Felder ') %]
                            </span>
                            <span class="fa fa-info" title="[% $user->gettext('Welche Standardfelder sollen für diesen Tickettyp verwendet werden.') %]"><i></i></span>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr class="heading">
                                            <th>[% $user->gettext('Feldname') %]</th>
                                            <th>[% $user->gettext('Anzeigen') %]</th>
                                            <th>[% $user->gettext('Pflichtfeld') %]</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>[% $user->gettext('Aufwand in Minuten') %]</td>
                                            <td><input type="checkbox" name="show[timecost]" [% if $Tools->FCS_InArray('timecost', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[timecost]" [% if $Tools->FCS_InArray("timecost", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Bearbeitungsart') %]</td>
                                            <td><input type="checkbox" name="show[edittype]" [% if $Tools->FCS_InArray('edittype', $show ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[edittype]" [% if $Tools->FCS_InArray("edittype", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Dokumente') %]</td>
                                            <td><input type="checkbox" name="show[document]" [% if $Tools->FCS_InArray('document', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[document]" [% if $Tools->FCS_InArray("document", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Entscheiderkreis') %]</td>
                                            <td><input type="checkbox" name="show[deccirle]" [% if $Tools->FCS_InArray('deccirle', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[deccirle]" [% if $Tools->FCS_InArray("deccirle", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Erwarteter Aufwand') %]</td>
                                            <td><input type="checkbox" name="show[expectedcost]" [% if $Tools->FCS_InArray('expectedcost', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[expectedcost]" [% if $Tools->FCS_InArray("expectedcost", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Eskalation') %]</td>
                                            <td><input type="checkbox" name="show[escalation]" [% if $Tools->FCS_InArray('escalation', $show ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Fällig am') %]</td>
                                            <td><input type="checkbox" name="show[desiredate]" [% if $Tools->FCS_InArray( 'desiredate', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[desiredate]" [% if $Tools->FCS_InArray("desiredate", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Geräteauswahl') %]</td>
                                            <td><input type="checkbox" name="show[choosedevice]" [% if $Tools->FCS_InArray('choosedevice', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[choosedevice]" [% if $Tools->FCS_InArray("choosedevice", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Geräteauswahl (LDAP)') %]</td>
                                            <td><input type="checkbox" name="show[choosedeviceldap]" [% if $Tools->FCS_InArray('choosedeviceldap', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[choosedeviceldap]" [% if $Tools->FCS_InArray("choosedeviceldap", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Geräte des Kontaktes') %]</td>
                                            <td><input type="checkbox" name="show[contactdevice]" [% if $Tools->FCS_InArray('contactdevice', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Gruppe') %]</td>
                                            <td><input type="checkbox" name="show[group]" [% if $Tools->FCS_InArray( 'group', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[group]" [% if $Tools->FCS_InArray("group", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Interessierter Kreis') %]</td>
                                            <td><input type="checkbox" name="show[interest]" [% if $Tools->FCS_InArray('interest', $show ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[interest]" [% if $Tools->FCS_InArray("interest", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Kategorie') %]</td>
                                            <td><input type="checkbox" name="show[category]"  [% if $Tools->FCS_InArray('category', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[category]" [% if $Tools->FCS_InArray("category", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Kategorie 2') %]</td>
                                            <td><input type="checkbox" name="show[category2]" [% if $Tools->FCS_InArray('category2', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[category2]" [% if $Tools->FCS_InArray("category2", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Masterticket') %]</td>
                                            <td><input type="checkbox" name="show[masterticket]" [% if $Tools->FCS_InArray('masterticket', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Priorität') %]</td>
                                            <td><input type="checkbox" name="show[priority]" [% if $Tools->FCS_InArray('priority', $show ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[priority]" [% if $Tools->FCS_InArray("priority", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Projekte') %]</td>
                                            <td><input type="checkbox" name="show[project]" [% if $Tools->FCS_InArray('project', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[project]" [% if $Tools->FCS_InArray("project", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Schlagworte') %]</td>
                                            <td><input type="checkbox" name="show[tag]" [% if $Tools->FCS_InArray('tag', $show ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[tag]" [% if $Tools->FCS_InArray('tag', $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Supporter') %]</td>
                                            <td><input type="checkbox" name="show[supporter]" [% if $Tools->FCS_InArray('supporter', $show) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[supporter]" [% if $Tools->FCS_InArray("supporter", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Ticketdatum') %]</td>
                                            <td><input type="checkbox" name="show[creationdate]" [% if $Tools->FCS_InArray('creationdate', $show ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td><input type="checkbox" name="require[creationdate]" [% if $Tools->FCS_InArray("creationdate", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Verknüpftes Ticket') %]</td>
                                            <td><input type="checkbox" name="show[connticket]" [% if $Tools->FCS_InArray('connticket', $show ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Vorlage') %]</td>
                                            <td></td>
                                            <td><input type="checkbox" name="require[tickettemplate]" [% if $Tools->FCS_InArray('tickettemplate', $require ) %] checked [% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %] /></td>

                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Zurückstellung') %]</td>
                                            <td><input type="checkbox" name="show[onholddate]" [% if $Tools->FCS_InArray('onholddate', $show ) %] checked [% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Workflow starten') %]</td>
                                            <td><input type="checkbox" name="show[workflow]" [% if $Tools->FCS_InArray('workflow', $show ) %] checked [% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td>[% $user->gettext('Incident Daten') %]</td>
                                            <td><input type="checkbox" name="show[incidentData]" [% if $Tools->FCS_InArray('incidentData', $show ) %] checked [% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %] /></td>
                                            <td><input type="checkbox" name="require[incidentData]" [% if $Tools->FCS_InArray("incidentData", $require ) %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]/></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-sm-6">
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <span class="fcs-card-title h4">
                                [% $user->gettext('Beschreibung') %]
                            </span>
                        </div>
                        <div class="card-body">
                            <textarea name="type_description" class="form-control" style="width:100%;" placeholder="[% $user->gettext('Schreiben Sie hier eine kurze Beschreibung des Tickettyps (max 250 Zeichen)') %]">[% $type.type_description %]</textarea>
                        </div>

                    </div>
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">

                            <span class="fcs-card-title h4">
                                [% $user->gettext('Vorhandene Felder') %]
                            </span>
                            <span class="fa fa-info" title="[% $user->gettext('Diese Felder müssen vorhanden sein und können nicht geändert werden.') %]"><i></i></span>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>[% $user->gettext('Feldname') %]</th>
                                            <th>[% $user->gettext('Feldtyp') %]</th>
                                            <th>[% $user->gettext('Pflichtfeld') %]</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>[% $user->gettext('Kontakt') %]</td>
                                            <td>[% $user->gettext('Textfeld') %]</td>
                                            <td style="text-align:center;"><input type="checkbox"  disabled="disabled"></td>
                                        </tr>

                                        <tr>
                                            <td>[% $user->gettext('Titel') %]</td>
                                            <td>[% $user->gettext('Textfeld') %]</td>
                                            <td style="text-align:center;"><input type="checkbox" checked="checked" disabled="disabled"></td>
                                        </tr>

                                        <tr>
                                            <td>[% $user->gettext('Beschreibung') %]</td>
                                            <td>[% $user->gettext('Textbereich') %]</td>
                                            <td style="text-align:center;"><input type="checkbox" checked="checked" disabled="disabled"></td>
                                        </tr>
                                        [% if $Sennebogen %]
                                            <tr id="">
                                                <td>[% $user->gettext('Betriebsstunden') %]</td>
                                                <td>[% $user->gettext('Nummer') %]</td>
                                                <td style="text-align:center;"><input type="checkbox" name="Betriebsstunden" [% if $type.bsnotrequired %][% else %]checked[% /if %]></td>
                                            </tr>
                                        [% /if %]

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">

                            <span class="fcs-card-title h4">
                                [% $user->gettext('Frei zu definierende Felder') %]
                            </span>
                            <span class="fa fa-info" title="[% $user->gettext('Hier können Sie angelegte Felder auswählen oder neue Felder erstellen.') %]"><i></i></span>
                        </div>
                        <div class="card-body">
                            [% if !$onlyshow || $original_type  %]
                                <div class="card panel-info shadow-sm rounded">
                                    <div class='card-body'>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <select id="fieldSelect" class="form-control" style="width:100%;">
                                                    <option value="0">[% $user->gettext('Ein existierendes Feld wählen') %]</option>
                                                    [% foreach from=$fieldList item=field %]
                                                        <option value="[% $field.field_id %]" title="[% $field.field_type %] [% if $field.comment %]- [% $field.comment %][% /if %]" [% if $TTFields|is_array && $TTFields[$field.field_id] %]disabled[% /if %]>[% $field.field_name %]</i></option>
                                                    [% /foreach %]
                                                </select>
                                            </div>

                                            <div class="col-sm-6">
                                                <a href="" class="btn btn-outline-secondary" title="[% $user->gettext('Neues Feld erstellen') %]" data-bs-toggle="modal" data-bs-target="#fieldModal">[% $user->gettext('Neues Feld') %]</a>
                                            </div>
                                        </div>

                                        <div class="row">

                                            <div class="col-sm-6">
                                                <select id="defFieldSelect" class="form-control" style="width:100%;">
                                                    <option value="0">[% $user->gettext('Auswahlliste wählen') %]</option>
                                                    [% foreach from=$defFieldList item=field %]
                                                        <option value="[% $field.userdeffieldid %]" title="[% $field.fielddescription %]" [% if $UDFields|is_array && $UDFields[$field.userdeffieldid] %]disabled[% /if %]>  [% $field.fieldname   %][%  if $field.fielddescription %] [% /if %]</i></option>
                                                    [% foreachelse %]
                                                    [% /foreach %]
                                                </select>
                                            </div>
                                            <div class="col-sm-6">
                                                <h4><span class="fa fa-info" title="[% $user->gettext('Sie können die Auswahllisten unter Einstellungen > Benutzerdefinierte Auswahllisten pflegen und anlegen.') %]"></span></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="fieldTable">
                                        <thead>
                                            <tr>
                                                <th title="[% $user->gettext('Ändern Sie die Reihenfolge der Felder durch Drag and Drop') %]"></th>
                                                <th>[% $user->gettext('Feldname') %]</th>
                                                <th>[% $user->gettext('Feldtyp') %]</th>
                                                <th>[% $user->gettext('Pflichtfeld') %]<br/><span class="small">[% $user->gettext('bei Ticketanlage') %]</span></th>
                                                <th>[% $user->gettext('Pflichtfeld') %]<br/><span class="small">[% $user->gettext('bei Ticketabschluss') %]</span></th>
                                                <th>[% $user->gettext('Mehrfachauswahl') %]</th>
                                                <th>[% $user->gettext('Gruppe') %]</th>
                                                [% if !$onlyshow || $original_type  %]<th class="text-center">[% /if %]</th>[% /if %]

                                            </tr>
                                        </thead>
                                        <tbody id="fieldBody">
                                            [% foreach from=$fullFieldList item=field %]
                                                [% if !$field.UDF %]
                                                    <tr id="row_field_[% $field.value.field_id %]">
                                                        <td  class="text-center" style="cursor:pointer;" title="[% $user->gettext('Ändern Sie die Reihenfolge der Felder durch Drag and Drop') %]"><h5><span class="fa fa-up-down"></span></h5></td>
                                                        <td>[% $field.value.field_name %]</td>
                                                        <td>[% $user->gettext($user->gettext($field.value.field_type)) %]</td>
                                                        <td style="text-align:center;"><input type="checkbox" name="required[[% $field.value.field_id %]]" id="required_[% $field.value.field_id %]" [% if $field.value.required == 1 %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]></td>
                                                        <td style="text-align:center;"><input type="checkbox" name="requiredOnClose[[% $field.value.field_id %]]" id="requiredOnClose_[% $field.value.field_id %]" [% if $field.value.requiredonclose == 1 %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]></td>
                                                        <td></td>
                                                        <td>
                                                            <select class='GroupSelect form-control' multiple="multiple" name='groups_fields_[% $field.value.field_id %][]'>
                                                       [% foreach from=$groups item=$group %]
                                                           <option [% if fcs_in_array($group.group_id, $field.value.Groups) %]selected='selected'[% /if %] value="[% $group.group_id %]">[% $group.name %]</option>;
                                                       [% /foreach %]
                                                            </select>
                                                        </td>
                                                        [% if  !$onlyshow || $original_type %]<td style="text-align:center;"><a  onclick="removeRow([% $field.value.field_id %]);" class="btn btn-sm btn-outline-secondary"><span class="fa fa-trash"></span></a></td>[% /if %]
                                                    </tr>
                                                [% else %]
                                                    <tr id="row_deffield_[% $field.value.userdeffieldid %]">
                                                        <td  class="text-center" style="cursor:pointer;" title="[% $user->gettext('Ändern Sie die Reihenfolge der Felder durch Drag and Drop') %]"><h5><span class="fa fa-up-down"></span></h5></td>
                                                        <td>[% $field.value.fieldname %]</td>
                                                        <td>[% if $field.value.showasradio %][% $user->gettext('Radioauswahl') %][% else %][% $user->gettext('Auswahlliste') %] [% /if %]</td>
                                                        <td style="text-align:center;"><input type="checkbox" [% if $field.valuecount == 0 %] disabled title="[% $user->gettext('Pflichtfeld nicht möglich, da noch keine Auswahlwerte definiert sind.') %]" [% /if %] name="requiredDef[[% $field.value.userdeffieldid %]]" id="required_def_[% $field.value.userdeffieldid %]" [% if $field.value.required == 1 %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]></td>
                                                        <td style="text-align:center;"><input type="checkbox" [% if $field.valuecount == 0 %] disabled title="[% $user->gettext('Pflichtfeld nicht möglich, da noch keine Auswahlwerte definiert sind.') %]" [% /if %] name="requiredOnCloseDef[[% $field.value.userdeffieldid %]]" id="requiredOnClose_def_[% $field.value.userdeffieldid %]" [% if $field.value.requiredonclose == 1 %]checked[% /if %] [% if $onlyshow && !$original_type  %]disabled="disabled"[% /if %]></td>
                                                        <td style="text-align:center;"><input type="checkbox" name="multipleDef[[% $field.value.userdeffieldid %]]" id="multiple_def_[% $field.value.userdeffieldid %]" [% if $field.value.multiple == 1 %]checked[% /if %] [% if ($onlyshow && !$original_type) || $field.value.showasradio %]disabled="disabled"[% /if %]></td>
                                                        <td>
                                                             <select class='GroupSelect form-control' multiple="multiple" name='groups_deffields_[% $field.value.userdeffieldid %][]'>
                                                        [% foreach from=$groups item=$group %]
                                                           <option [% if fcs_in_array($group.group_id, $field.value.Groups) %]selected='selected'[% /if %] value="[% $group.group_id %]">[% $group.name %]</option>;
                                                       [% /foreach %]
                                                             </select>
                                                        </td>
                                                        [% if  !$onlyshow || $original_type %]<td style="text-align:center;"><a  onclick="removeDefRow([% $field.value.userdeffieldid %]);" class="btn btn-sm btn-outline-secondary"><span class="fa fa-trash"></span></a></td>[% /if %]
                                                    </tr>
                                                [% /if %]
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <script>
        $('#fieldBody').sortable();
        $('#defFieldBody').sortable();

        $.get('index.php?module=tickettype&event=getIconsAsJSON', function (data) {
            $('#icon').select2({theme: 'bootstrap-5',
                data: JSON.parse(data),
                templateResult: formatIcon,
                templateSelection: formatIcon
            });
            $('#icon').val("[% $type.icon_id %]").trigger('change');
        });

        $('#fieldSelect').select2({theme: 'bootstrap-5'});
        $('#defFieldSelect').select2({theme: 'bootstrap-5'});

        function formatIcon(icon) {

            if (!icon.id || icon.id == 0) {
                return icon.text;
            }

            var $icon = $(
                    '<span><img src="index.php?module=upload&class=download&event=ShowImage&name=' + icon.path + '" style="max-width:22px;"  /> ' + icon.text + '</span>'
                    );

            return $icon;
        }
        ;

        $("#fieldSelect").on('change', function () {
            var id = $(this).val();
            if (id != 0) {
                $.get("index.php?module=field&event=getFieldsJSONByID&id=" + id, function (data) {
                    var fieldData = JSON.parse(data);
                    var type = '';
                    if (fieldData.field_type == 'text') {
                        type = 'Textfeld';
                    }
                    if (fieldData.field_type == 'textarea') {
                        type = 'Textbereich';
                    }
                    if (fieldData.field_type == 'checkbox') {
                        type = 'Checkbox';
                    }
                    if (fieldList.indexOf(parseInt(fieldData.field_id)) <= -1) {
                        var html = '<tr id="row_field_' + fieldData.field_id + '">';
                        html += '<td  class="text-center" title="[% $user->gettext('Ändern Sie die Reihenfolge der Felder durch Drag and Drop') %]"><h5><span class="fa fa-up-down"></span></h5></td>';
                        html += '<td>' + fieldData.field_name + '</td>';
                        html += '<td>' + type + '</td>';
                        html += '<td style="text-align:center;"><input type="checkbox" name="required[' + fieldData.field_id + ']" id="required_' + fieldData.field_id + '"></td>';
                        html += '<td style="text-align:center;"><input type="checkbox" name="requiredOnClose[' + fieldData.field_id + ']" id="requiredOnClose_' + fieldData.field_id + '"></td>';
                        html += '<td style="text-align:center;"></td>';
                        html += '<td><select style="width: 100%;" name="groups_fields_'+fieldData.field_id+'[]" multiple="multiple" class="groups_fields_'+fieldData.field_id+'">';
                        [% foreach from=$groups item=$group %]
                             html += '<option value="[% $group.group_id %]">[% $group.name %]</option>';
                        [% /foreach %]
                        html += '</select></td>';
                        html += '<td style="text-align:center;"><a  onclick="removeRow(' + fieldData.field_id + ');" class="btn btn-sm btn-outline-secondary"><span class="fa fa-trash"></span></a></td>';
                        html += '</tr>';
                        $("#fieldBody").append(html);
                        fieldList.push(parseInt(fieldData.field_id));
                        $("#fields").val(JSON.stringify(fieldList));

                        $("#fieldSelect option[value=" + id + "]").prop('disabled', true);
                        $("#fieldSelect").val(0);
                        $("#fieldSelect").select2({theme: 'bootstrap-5'});
                        $(".groups_fields_"+fieldData.field_id).select2({theme: 'bootstrap-5'});

                    }
                })

            }

        });

        $("#defFieldSelect").on('change', function () {
            var id = $(this).val();
            if (id != 0) {
                $.get("index.php?module=userfield&event=getFieldJSON&id=" + id, function (data) {
                    if (data != 0) {
                        var fieldData = JSON.parse(data);
                        if (defFieldList.indexOf(parseInt(fieldData.userdeffieldid)) <= -1) {

                            var requiredDisabledPart = '';
                            if(!fieldData.RequiredAble){
                                requiredDisabledPart = " disabled title='[% $user->gettext('Pflichtfeld nicht möglich, da noch keine Auswahlwerte definiert sind.') %]' ";
                            }

                            var html = '<tr id="row_deffield_' + fieldData.userdeffieldid + '">';
                            html += '<td  class="text-center" title="[% $user->gettext('Ändern Sie die Reihenfolge der Felder durch Drag and Drop') %]"><h5><span class="fa fa-up-down"></span></h5></td>';
                            html += '<td>' + fieldData.fieldname + '</td>';

                            if (fieldData.showasradio !== 1) {
                                html += '<td>' + '[% $user->gettext('Auswahlliste') %]' + '</td>';
                            } else {
                                html += '<td>' + '[% $user->gettext('Radioauswahl') %]' + '</td>';
                            }

                            html += '<td style="text-align:center;"><input type="checkbox" '+ requiredDisabledPart +' name="requiredDef[' + fieldData.userdeffieldid + ']" id="required_def_' + fieldData.userdeffieldid + '"></td>';
                            html += '<td style="text-align:center;"><input type="checkbox" '+ requiredDisabledPart +' name="requiredOnCloseDef[' + fieldData.userdeffieldid + ']" id="requiredOnClose_def_' + fieldData.userdeffieldid + '"></td>';
                            if (fieldData.showasradio !== 1) {
                                html += '<td style="text-align:center;"><input type="checkbox" name="multipleDef[' + fieldData.userdeffieldid + ']" id="multiple_def_' + fieldData.userdeffieldid + '"></td>';
                            } else {
                                html += '<td style="text-align:center;"></td>';
                            }
                            html += '<td><select style="width: 100%;" name="groups_deffields_'+fieldData.userdeffieldid+'[]" multiple="multiple" class="groups_deffields_'+fieldData.userdeffieldid+'">';
                            [% foreach from=$groups item=$group %]
                             html += '<option value="[% $group.group_id %]">[% $group.name %]</option>';
                            [% /foreach %]
                            html += '</select></td>';
                            html += '<td style="text-align:center;"><a  onclick="removeDefRow(' + fieldData.userdeffieldid + ');" class="btn btn-sm btn-outline-secondary"><span class="fa fa-trash"></span></a></td>';
                            html += '</tr>';
                            $("#fieldBody").append(html);
                            defFieldList.push(parseInt(fieldData.userdeffieldid));
                            //$("#fields").val(JSON.stringify(fieldList));
                            
                            $("#defFieldSelect option[value=" + id + "]").attr('disabled', 'disabled');
                            $("#defFieldSelect").val(0).select2({theme: 'bootstrap-5'});
                            $(".groups_deffields_"+fieldData.userdeffieldid).select2({theme: 'bootstrap-5'});

                        }

                    }
                })
            }
        });

        function removeFromArr(arr, value) {
            arr = arr.filter(function (item) {
                return item !== value
            });
            return arr;
        }

        function removeRow(id) {
            //console.log("Before: " + fieldList);
            $('#row_field_' + id).remove();
            fieldList = removeFromArr(fieldList, id);
            //console.log("After: " + fieldList);
            $("#fields").val(JSON.stringify(fieldList));

            $("#fieldSelect option[value=" + id + "]").prop('disabled', false);
            $("#fieldSelect").select2({theme: 'bootstrap-5'});

        }

        function removeDefRow(id) {
            $('#row_deffield_' + id).remove();
            defFieldList = removeFromArr(defFieldList, id);
            $("#fields").val(JSON.stringify(fieldList));
            $("#defFieldSelect option[value=" + id + "]").prop('disabled', false);
            $("#defFieldSelect").select2({theme: 'bootstrap-5'});
        }

        var fieldList = [];
        var defFieldList = [];

        [% foreach from=$fullFieldList item=field %]
            [% if !$field.UDF %]
        fieldList.push(parseInt([% $field.value.field_id %]));
            [% else %]
        defFieldList.push(parseInt([% $field.value.userdeffieldid %]));
            [% /if %]

        [% /foreach %]

        $("#fields").val(JSON.stringify(fieldList));
        function selectForm() {
            var field_type = $("#field_select_type").val();
            if (field_type == "text") {
                addText();
            }
            if (field_type == "textarea" || field_type == "0") {
                addTextarea();
            }


        }
        function deleteField(id) {
            bootbox.confirm("[% $user->gettext('Feld wirklich löschen?') %]", function (result) {
                if (result) {
                    $.post('index.php?module=field&event=deleteField&id=' + id, function (data) {

                        if (data == 1) {
                            location.reload();
                        }
                    })
                }
            })
        }

        function saveField() {
            var formObj = {};
            formObj.name = $("#fieldName").val();
            formObj.comment = $("#fieldComment").val();
            formObj.type = $("#field_select_type").val();
            if (formObj.name == "" || formObj.id == "" || formObj.type == "" || formObj.type == "0") {
                noty({
                    text: "[% $user->gettext("Bitte alle Daten eingeben") %]",
                    type: 'error',
                    timeout: notifyTimeout
                });
                return;
            }
            if (formObj.type == "text") {
                formObj.check = $("#form_check").val();
                formObj.password = $("#form_pass").is(":checked");
                formObj.spaceAllowed = !$("#form_space").is(":checked");
            } else if (formObj.type == "checkbox" || formObj.type == "textarea") {

            }



            $.post('index.php?module=field&event=storeField',
                    {fieldData: JSON.stringify(formObj)},
                    function (data) {
                        if (data == -1) {
                            noty({
                                text: "[% $user->gettext('Es gibt schon ein Feld mit diesem Namen.') %]",
                                type: 'error',
                                timeout: notifyTimeout
                            });
                            return;
                        }
                        var type = $("#field_select_type").val();
                        if ($("#field_select_type").val() == 'text') {
                            type = 'Textfeld';
                        }
                        if ($("#field_select_type").val() == 'textarea') {
                            type = 'Textbereich';
                        }
                        if ($("#field_select_type").val() == 'checkbox') {
                            type = 'Checkbox';
                        }

                        var html = '<tr id="row_field_' + data + '">';
                        html += '<td  class="text-center" title="[% $user->gettext('Ändern Sie die Reihenfolge der Felder durch Drag and Drop') %]"><h5><span class="fa fa-up-down"></span></h5></td>';
                        html += '<td>' + $("#fieldName").val() + '</td>';
                        html += '<td>' + type + '</td>';
                        html += '<td style="text-align:center;"><input type="checkbox" name=required[' + data + '] id="required_' + data + '"></td>';
                        html += '<td style="text-align:center;"><input type="checkbox" name=requiredOnClose[' + data + '] id="requiredOnClose_' + data + '"></td>';
                        html += '<td style="text-align:center;"></td>';
                        html += '<td><select style="width: 100%;" name="groups_fields_'+data+'[]" multiple="multiple" class="groups_fields_'+data+'">';
                        [% foreach from=$groups item=$group %]
                             html += '<option value="[% $group.group_id %]">[% $group.name %]</option>';
                        [% /foreach %]
                        html += '</select></td>';
                        html += '<td style="text-align:center;"><a  onclick="removeRow(' + data + ');" class="btn btn-outline-secondary"><span class="fa fa-trash"></span></a></td>';
                        html += '</tr>';
                        $("#fieldBody").append(html);
                        fieldList.push(data);
                        $("#fields").val(JSON.stringify(fieldList));
                        $("#fieldModal input").val("");
                        $("#field_select_type").val("0");
                        $("#fieldDiv").empty();
                        $("#fieldModal").modal('hide');
                        $('.groups_fields_'+data).select2({theme: 'bootstrap-5'});
                    }
            )
        }



        function addTextarea() {
            $("#fieldDiv").empty();
        }

        var optNum = 1;
        function addOption() {
            var html = '<div class="input-group" id="opt_' + optNum + '">';
            html += '<input type="text" class="form-control options" name="options[]"  value="" placeholder="Option" />';
            html += '<div class="input-group-text"><span class="fa fa-trash  btn-outline-secondary" onclick="$(\'#opt_' + optNum + '\').remove();"></span></div>';
            html += '</div>';
            $("#field_options").append(html);
            optNum++;
        }

        function addText() {
            $("#fieldDiv").empty();
            var html = '<div class="form-group row mb-3">';
            html += '<label class="control-panel col-lg-3">';
            html += '[% $user->gettext("Datentyp") %]:';
            html += '</label>';
            html += '<div class="col-lg-9">';
            html += '<select id="form_check" class="form-control">';
            html += '<option value="">[% $user->gettext('Texte') %]</option>';
            html += '<option value="int">[% $user->gettext("Nur Zahlen") %]</option>';
            html += '<option value="dmY">[% $user->gettext("Datum (d.m.Y)") %]</option>';
            html += '<option value="dmYhm">[% $user->gettext("Datum + Zeit") %]</option>';
            html += '</select>';
            html += '</div>';
            html += '</div>';
            html += '<div class="form-group row mb-3">';
            html += '<label class="control-panel col-lg-3">';
            html += '[% $user->gettext("Passwortfeld") %]:';
            html += '</label>';
            html += '<div class="col-lg-9">';
            html += '<input type="checkbox" id="form_pass" />';
            html += '</div>';
            html += '</div>';
            $("#fieldDiv").append(html);
        }

        $('#TypeTemplate').on("change", function () {
            if ($(this).val() == 0) {
                window.location.assign("index.php?module=tickettype&event=create");
            } else {
                window.location.assign("index.php?module=tickettype&event=copy&oType=" + $(this).val());
            }
        })

        $(document).ready(function () {

            bootbox.setDefaults({
                /**
                 * @optional String
                 * @default: en
                 * which locale settings to use to translate the three
                 * standard button labels: OK, CONFIRM, CANCEL
                 */
                locale: ts_lang,
                title: "[% $user->gettext('<b>Achtung</b>: Tickettyp ist in Verwendung') %]",
                /**
                 * @optional Boolean
                 * @default: true
                 * whether the dialog should be shown immediately
                 */
                show: true,
                /**
                 * @optional Boolean
                 * @default: true
                 * whether the dialog should be have a backdrop or not
                 */
                backdrop: true,
                /**
                 * @optional Boolean
                 * @default: true
                 * show a close button
                 */
                closeButton: true,
                /**
                 * @optional Boolean
                 * @default: true
                 * animate the dialog in and out (not supported in < IE 10)
                 */
                animate: true,
                /**
                 * @optional String
                 * @default: null
                 * an additional class to apply to the dialog wrapper
                 */
                className: null
            });
        })

        var change_active = true;

        function checkForm() {
            var fieldList = [];
            var defFieldList = [];
            if (!change_active) {
                $('#fieldTable tr').each(function () {
                    var id = $(this).attr('id');
                    if (id != undefined) {
                        if (id.indexOf('row_deffield_') != -1) {
                            fieldList.push(id.replace('row_deffield_', 'udf_'));
                        } else if (id.indexOf('row_field_') != -1) {
                            fieldList.push(id.replace('row_field_', 'df_'));
                        }

                    }
                })

                $("#fields").val(JSON.stringify(fieldList));
                $('#hm1').submit();
                return;
            }
            var type_name = $('#name').val();
            if (type_name == "") {
                alert('Tickettyp muss Name haben');
                return;
            }
        [% if $type.type_name %]
            if ('[% $type.type_name %]' != type_name) {
                $.post('index.php?module=tickettype&event=checkName', {type_name: type_name}, function (data) {
                    if (data == 1) {
            [% if $hasTicket && !$copy %]
                        bootbox.confirm('[% $user->gettext('<p>Dieser Tickettyp wird schon verwendet. Änderungen können zu Unstimmigkeiten im Ticket führen.</p><p>Trotzdem fortsetzen?</p>') %]', function (result) {
                            if (result) {

                                $('#fieldTable tr').each(function () {
                                    var id = $(this).attr('id');
                                    if (id != undefined) {
                                        if (id.indexOf('row_deffield_') != -1) {
                                            fieldList.push(id.replace('row_deffield_', 'udf_'));
                                        } else if (id.indexOf('row_field_') != -1) {
                                            fieldList.push(id.replace('row_field_', 'df_'));
                                        }

                                    }
                                })

                                $("#fields").val(JSON.stringify(fieldList));
                                //console.log(fieldList);

                                // $("#defFields").val(JSON.stringify(defFieldList));
                                $('#hm1').submit();
                            }
                        });
            [% else %]
                        $('#fieldTable tr').each(function () {
                            var id = $(this).attr('id');
                            if (id != undefined) {
                                if (id.indexOf('row_deffield_') != -1) {
                                    fieldList.push(id.replace('row_deffield_', 'udf_'));
                                } else if (id.indexOf('row_field_') != -1) {
                                    fieldList.push(id.replace('row_field_', 'df_'));
                                }
                            }
                        })
                        $("#fields").val(JSON.stringify(fieldList));
                        $('#hm1').submit();
            [% /if %]
                    }
                    if (data == 0) {
                        noty({
                            text: "[% $user->gettext("Es gibt schon einen Typ mit diesem Namen.") %]",
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    }
                });
            } else {
            [% if $hasTicket && !$copy %]
                bootbox.confirm('[% $user->gettext('<p>Dieser Tickettyp wird schon verwendet. Änderungen können zu Unstimmigkeiten im Ticket führen.</p><p>Trotzdem fortsetzen?</p>') %]', function (result) {
                    if (result) {
                        $('#fieldTable tr').each(function () {
                            var id = $(this).attr('id');
                            if (id != undefined) {
                                if (id.indexOf('row_deffield_') != -1) {
                                    fieldList.push(id.replace('row_deffield_', 'udf_'));
                                } else if (id.indexOf('row_field_') != -1) {
                                    fieldList.push(id.replace('row_field_', 'df_'));
                                }
                            }
                        })
                        $("#fields").val(JSON.stringify(fieldList));
                        //console.log(fieldList);
                        $('#hm1').submit();
                    }
                }
                );
            [% else %]
                $('#fieldTable tr').each(function () {
                    var id = $(this).attr('id');
                    if (id != undefined) {
                        if (id.indexOf('row_deffield_') != -1) {
                            fieldList.push(id.replace('row_deffield_', 'udf_'));
                        } else if (id.indexOf('row_field_') != -1) {
                            fieldList.push(id.replace('row_field_', 'df_'));
                        }
                    }
                })
                $("#fields").val(JSON.stringify(fieldList));
                // $("#defFields").val(JSON.stringify(defFieldList));
                //console.log(fieldList);
                $('#hm1').submit();
            [% /if %]
            }
        [% /if %]
        }
        $(".GroupSelect").select2({theme: 'bootstrap-5'});
    </script>
