<link rel="stylesheet" href="includes/js/cropper/cropper.css">

<!-- Latest compiled and minified JavaScript -->
<script src="includes/js/cropper/cropper.js"></script>


<style>
    .container {
      margin: 20px auto;
      max-width: 640px;
    }

    img {
      max-width: 100%;
    }

    .cropper-view-box,
    .cropper-face {
      border-radius: 50%;
    }
  </style>
<div class="card panel-fcs-border shadow-sm">
	<div class="card-header">
		<div class="row">
			<div class="col-sm-6">
				<div class="fcs-card-title h1">[% $user->gettext('Bild zuschneiden')%]</div>
			</div>
			<div class="col-sm-6 text-end">
				<a href="javascript:saveCroppedImage();" class="btn btn-outline-primary">[% $user->gettext('Speichern') %]</a>

			</div>
		</div>
	</div>
	<div class="card-body">
		<div class="row">
			<div class="col-sm-6">
				<div>
					<img id="image" src="index.php?module=upload&class=download&event=ShowImage&name=[%  $image %]" style="max-width: 500px;">
				</div>
			</div>
			<div class="col-sm-6 text-center">
				<div id="result" style="margin: auto; max-width: 200px;"></div>
			</div>
		</div>
	</div>
</div>
  <script>
	var imageBase64 = '';	
    function getRoundedCanvas(sourceCanvas) {
      var canvas = document.createElement('canvas');
      var context = canvas.getContext('2d');
      var width = sourceCanvas.width;
      var height = sourceCanvas.height;

      canvas.width = width;
      canvas.height = height;
      context.imageSmoothingEnabled = true;
      context.drawImage(sourceCanvas, 0, 0, width, height);
      context.globalCompositeOperation = 'destination-in';
      context.beginPath();
      context.arc(width / 2, height / 2, Math.min(width, height) / 2, 0, 2 * Math.PI, true);
      context.fill();
      return canvas;
    }

    window.addEventListener('DOMContentLoaded', function () {
      var image = document.getElementById('image');
      var button = document.getElementById('button');
      var result = document.getElementById('result');
      var croppable = false;
      var cropper = new Cropper(image, {
        aspectRatio: 1,
        viewMode: 1,
        ready: function () {
          croppable = true;
        },
      });
	 
	  document.getElementById('image').addEventListener('cropmove', (event) => {
		var croppedCanvas;
        var roundedCanvas;
        var roundedImage;

        if (!croppable) {
          return;
        }

        // Crop
        croppedCanvas = cropper.getCroppedCanvas();

        // Round
        roundedCanvas = getRoundedCanvas(croppedCanvas);

        // Show
        roundedImage = document.createElement('img');
        imageBase64 = roundedCanvas.toDataURL();
        roundedImage.src = imageBase64;
        result.innerHTML = '';
        result.appendChild(roundedImage);
	  });

     
    });
	function saveCroppedImage(){
		$.ajax({
        url:    [% if $module !='group' %] "index.php?module=user&event=saveCroppedAvatar" [% else %]"index.php?module=groups&event=saveCroppedAvatar"[% /if %],
        data:{
          [% if $id || $groupid %][% if $id && !$groupid %] id: [% $id %],[% else if !$id && $groupid %] id: [% $groupid %], [% /if %][% /if %]
          base64: imageBase64,
          image: '[% $image %]'
        },
        type:"post",
        complete:function(data){
            console.log(data);
          parent.updateAvatar(data.responseText);
          parent.closeIFrame();
        }
      });
}
  </script>