<!-- workflow_list.tpl -->
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>
<form action="" method="post" name="hm" id="hm-WFListForm" enctype="multipart/form-data" >

    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
    <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />


    <!-- ###CONTENT### begin -->
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[% $user->gettext('Definierte Workflows')%]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">

                        </div>
                        <div class="col-lg-6 text-end">
                            [% if $user->hasRight(703) %]
                                <div class="btn-group">
                                    <input type="button" class="btn btn-outline-primary" onclick="window.location.href = 'index.php?module=workflow&event=create'" value="[% $user->gettext('Neue Workflowdefinition') %]" />
                                </div>
                            [% /if %]
                        </div>
                    </div>
                </div>
            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">[% if $available %][% $user->gettext('Verfügbare Workflows') %][% else %][% $user->gettext('Definierte Workflows') %][% /if %]</span><span class="fcs-card-title"> - [% $entries %] [% $user->gettext('Vorlage(n)') %] [% $user->gettext('gefunden') %]</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="fields">
                                    <th>
                                        [% $user->gettext('Bezeichnung') %]
                                    </th>

                                    <th>
                                        [% $user->gettext('Anzahl Aktivit&auml;ten') %]
                                    </th>
                                    [% if !$available %]
                                        <th>
                                            [% $user->gettext('Freigabe') %]
                                        </th>
                                    [% /if %]
                                    <th>
                                        [% $user->gettext('Aktion') %]
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$workflows item=wf %]
                                    <tr [% if $available %]style="line-height: 30px;"[% /if %]>
                                        <td>
                                            [% $wf.Description %]
                                        </td>

                                        <td>
                                            [% $wf.countActivities %]
                                        </td>
                                        [% if !$available %]
                                            <td>
                                                [% if $wf.Published == 1%]
                                                    [% $user->gettext('Ja') %]
                                                [% else %]
                                                    [% $user->gettext('Nein') %]
                                                [% /if %]
                                            </td>
                                        [% /if %]
                                        <td>
                                            [% if $available %]
                                                <a href="index.php?module=workflow&event=activate&wfdid=[% $wf.ID %]" class="btn btn-outline-primary">
                                                    [%*<span class="fa fa-check" title="[% $user->gettext('Aktivieren') %]"></span>*%]
                                                    Starten
                                                </a>
                                            [% else %]
                                                <a href="index.php?module=workflow&event=published&wfdid=[% $wf.ID %]" onclick="return confirm('[% $wf.Description %]\n[% if $wf.Published == 1 %][% $user->gettext('wirklich verbergen?') %][% else %][% $user->gettext('wirklich freigeben?') %][% /if %]');" class="btn btn-outline-secondary"><span class="fa fa-[% if $wf.Published == 1 %]xmark[% else %]plus[% /if %]" title="[% if $wf.Published == 1 %][% $user->gettext('Verbergen') %][% else %][% $user->gettext('Freigeben') %][% /if %]"></span></a>
                                                <a href="index.php?module=workflow&event=removewfd&wfdid=[% $wf.ID %]" onclick="return confirm('[% $wf.Description %]\n[% $user->gettext('wirklich entfernen?') %]');" class="btn btn-outline-secondary"><span class="fa fa-trash" title="[% $user->gettext('Entfernen') %]"></span></a>
                                                <a href="index.php?module=workflow&event=editwfd&wid=[% $wf.ID %]" class="btn btn-outline-secondary"><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>
                                                <a href="index.php?module=workflow&event=activate&wfdid=[% $wf.ID %]" class="btn btn-outline-secondary"><span class="fa fa-check" title="[% $user->gettext('Aktivieren') %]"></span></a>
                                                <a href="index.php?module=workflow&event=copywfd&wfdid=[% $wf.ID %]" class="btn btn-outline-secondary"><span class="fa fa-copy" title="[% $user->gettext('Kopieren') %]"></span></a>
                                                [% /if %]
                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td>
                                            [% $user->gettext('Keine Einträge gefunden') %]
                                        </td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
                            <script>
                                 $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    });
                                </script>