<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>


<div class="panel panel-fcs-border">
    <div class="panel-heading">
        <div class="row">
            <div class="col-sm-6">
                <span class="fcs-card-title h2">[% $user->gettext('Kostenartikel') %]</span>
            </div>
            <div class="col-sm-6 text-right">
                <div class="btn-group">
<input type="button" onclick="window.location.href = 'index.php?module=wprequest&class=wage&event=CSVImport';" value="[% $user->gettext('CSV-Import') %]" class="btn btn-outline-primary" />

                    <input type="button" onclick="window.location.href = 'index.php?module=wprequest&class=wage&event=create';" value="[% $user->gettext('Neuer Kostenartikel') %]" class="btn btn-outline-primary" />
                </div>

            </div>
        </div>
    </div>
    <div class="panel-body">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <h3 class="card-title">[% $entries %] [% $user->gettext('Einträge') %]</h3>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="WarrantyProcessingTypeTable" >
                            <thead>
                                <tr>
                                    <th>
                                        [% $user->gettext('Kunden Nr') %]
                                    </th>
                                    <th>
                                        [% $user->gettext('Bezeichnung') %]
                                    </th>
                                    <th>
                                        [% $user->gettext('Arbeit') %]
                                    </th>
                                    <th>[% $user->gettext('Reise') %]</th>
                                    <th>[% $user->gettext('KM') %]</th>
                                    <th>[% $user->gettext('Max. KM') %]</th>
                                    <th>[% $user->gettext('Hinweis') %]</th>
                                    <th>[% $user->gettext('Gültig von') %]</th>
                                    <th>[% $user->gettext('Gültig bis') %]</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$Wages item=Wage %]
                                    <tr>
                                        <td>[% $Wage.DealerID %]</td>
                                        <td>[% $Wage.Description %]</td>
                                        <td>[% $Wage.WorkPrice %]</td>
                                        <td>[% $Wage.TravelPrice %]</td>
                                        <td>[% $Wage.KmPrice %]</td>
                                        <td>[% $Wage.MaxKm %]</td>
                                        <td>[% $Wage.HintText %]</td>
                                        <td data-sort="[% $Wage.ValidFrom|date_format:'%Y%m%d' %]">[% $Wage.ValidFrom|date_format:"%d.%m.%Y" %]</td>
                                        <td data-sort="[% $Wage.ValidUntil|date_format:'%Y%m%d' %]">[% $Wage.ValidUntil|date_format:"%d.%m.%Y" %]</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="index.php?module=wprequest&class=wage&event=edit&WarrantyRequestWageID=[% $Wage.WarrantyRequestWageID %]" title="[% $user->gettext('Bearbeiten') %]" class="btn btn-outline-secondary"><span class="fa fa-pencil"></span></a>
                                            </div>
                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="8">[% $user->gettext('Es wurden keine Kostenartikel gefunden') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
    </div>
</div>


<script>
    $(document).ready(function () {

        table = $('table').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 50,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
        var data = table.buttons.exportData({
            columns: ':visible'
        });

    });
</script>
