<html>
<style>
    #ShoppingCart tr.odd > td{
        background-color: #f8f9fa;
    }

    #ShoppingCart tr.even > td{
        background-color: #ffffff;
    }

</style>
    <body>
        <input type="hidden" id="totalPriceInput" value="{{ $totalPrice }}">
        <h1>{{ __('ADOrderCatalog.Warenkorb') }}</h1>

        <div class="row">
            <div class="col-12">
                <label for="myCartOrderForText">{{ __('ADOrderCatalog.BestellungFuer') }}</label><br />
                <input type="text" name="CartOrderNotice" id="myCartOrderNotice" value="{{ $Cart->CartOrderNotice ?? '' }}" placeholder="{{ __('ADOrderCatalog.BestellungFuer') }}..." maxlength="250" class="form-control" />
                <hr />
                <br />
            </div>

            <div class="col-12">
                <div class="table-responsive">
                    <table id="ShoppingCart" class = "table">
                        <thead>
                            <tr>
                                <td>{{ __('ADOrderCatalog.Artikelnr') }}</td>
                                <td>{{ __('ADOrderCatalog.Artikel') }}</td>
                                <td>{{ __('ADOrderCatalog.Lierferant') }}</td>
                                <td>{{ __('ADOrderCatalog.Menge') }}</td>
                                <td>{{ __('ADOrderCatalog.Geliefert') }}</td>
                                <td class="text-right">{{ __('ADOrderCatalog.Einzelpreis') }}</td>
                                <td>{{ __('ADOrderCatalog.Aktion') }}</td>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($ShoppingCart as $Entry)
                            <tr id="row_{{ $Entry->ADShoppingCartArticleID }}" class="{{ $loop->odd ? 'odd' : 'even' }}">
                        <input type="hidden" id="OldAmount_{{ $Entry->ADShoppingCartArticleID }}" value="{{ $Entry->Amount }}">
                        <td @if (!empty($Entry->OrderText)) rowspan="2"@endif>{{ $Entry->ArticleNo }}</td>
                        <td>@if($Entry->IsDummy)<input id="ArticleName_{{ $Entry->ADShoppingCartArticleID }}" value="@if($Entry->ArticleDummyName == null){{ $Entry->ArticleName }}@else{{ $Entry->ArticleDummyName}}@endif" />@else {{ $Entry->ArticleName }} @endif </td>
                        <td>{{ $Entry->Vendor }}</td>

                        <td><input type="number" class="numberInput"  @if($Entry->DeliveredAmount) min="{{ $Entry->DeliveredAmount }}" @else min="1" @endif id="Amount_{{ $Entry->ADShoppingCartArticleID }}" value="{{ $Entry->Amount }}"></td>
                        <td>{{ $Entry->DeliveredAmount }}</td>
                        <td style="text-align:right;">{{ number_format( $Entry->Price, 2, ',', '.' ) }} {{ $Entry->Currency }}</td>
                        <input type="hidden" id="Price_{{ $Entry->ADShoppingCartArticleID }}" value="{{ $Entry->Price }}">

                        <td>
                            <button title="Speichern" class="btn btn-default" @if(!$Entry->IsEditable) disabled="disabled" @endif onclick="saveArticle({{ $Entry->ADShoppingCartArticleID }})"><span class="fa fa-floppy-disk"></span></button>
                            <button title="Entfernen" class="btn btn-default" @if(!$Entry->IsEditable ||$Entry->DeliveredAmount > 0) disabled="disabled" @endif onclick="removeArticle({{ $Entry->ADShoppingCartArticleID }})"><span class="fa fa-trash"></span></button></td>
                        </tr>

                                    @if (!empty($Entry->OrderText))
                            <tr class="{{ $loop->odd ? 'odd' : 'even' }}">
                                <td colspan="2">Bemerkung zum Artikel:</td>
                                <td colspan="4">{!! $Entry->OrderText !!}</td>
                            </tr>

                                    @endif                                
                        @empty
                        <tr><td colspan="7">Ihr Warenkorb ist leer.</tr>
                        @endforelse
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="5" class="text-right"><strong>{{ __('ADOrderCatalog.Gesamtpreis') }}</strong></td>
                                <td class="text-right">
                                    <strong id="TotalPrice">{{ number_format( $totalPrice, 2, ',', '.') }} {{ $Currency }}</strong>
                                    <input type="hidden" id="totalPriceFloat" value="{{ $totalPrice }}" />
                                </td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>



            <div class="col-12">
                <label for="myCartOrderText">{{ __('ADOrderCatalog.BemerkungZurBestellung') }}</label><br />
                <textarea rows=2 placeholder="{{ __('ADOrderCatalog.BemerkungZurBestellung') }}" name="CartOrderText" id="myCartOrderText" class="form-control" maxlength="300" style="width:100%;">{{ $Cart->CartOrderText ?? ''}}</textarea>
            </div>
            
        </div>
        <hr />
        <h2>Artikelauswahl</h2>
    </body>

<script>


        $('#myCartOrderText').on('blur', function (e) {

            $.ajax({
                type: "POST",
                url: "ordercatalog/changeCartOrderText",
                data: {
                    ActivityID: aid,
                    ADShoppingCartID: $('#ADShoppingCart').val(),
                    CartOrderText: $(this).val()
                }
            }).done(function (response) {

                if (typeof response === 'object') {

                    $("#ADOrderCatalogError").append('<h4>Fehler</h4>');
                    var keys = Object.keys(response);
                    for (var i = 0; i < keys.length; i++) {
                        response[keys[i]].forEach((message) => {
                            $("#ADOrderCatalogError").append('<li>' + message + '</li>');
                        });
                    }
                } else {

                }
            })
        })


        $('#myCartOrderNotice').on('blur', function (e) {
        CartOrderNotice = $(this).val();
            $.ajax({
                type: "POST",
                url: "ordercatalog/changeCartOrderNotice",
                data: {
                    ActivityID: aid,
                    ADShoppingCartID: $('#ADShoppingCart').val(),
                    CartOrderNotice: CartOrderNotice
                }
            }).done(function (response) {

                if (typeof response === 'object') {

                    $("#ADOrderCatalogError").append('<h4>Fehler</h4>');
                    var keys = Object.keys(response);
                    for (var i = 0; i < keys.length; i++) {
                        response[keys[i]].forEach((message) => {
                            $("#ADOrderCatalogError").append('<li>' + message + '</li>');
                        });
                    }
                } else {

                }
            })
        })
</script>
</html>
