
<strong>Bestellung für:</strong> {{ $Cart?->CartOrderNotice ?? '' }}
<br/>
<strong>Bemerkung:</strong> {{ $Cart?->CartOrderText ?? '' }}

<br/>
<hr />
<table class = "table table-striped">
    <thead>
        <tr>
            <td>Artikelnr.</td>
            <td>Artikel</td>
            <td>Lierferant</td>
            <td class="text-right">Einzelpreis</td>
            <td>Menge</td>            
            <td>Geliefert</td>
            <td>Bemerkung</td>
        </tr>
    </thead>
    <tbody>
        @if($ShoppingCart!== NULL)
        @forelse ($ShoppingCart as $Entry)
        <tr id="row_{{ $Entry->ADShoppingCartArticleID }}">
            <td>{{ $Entry->ArticleNo }}</td>
            <td>{{ $Entry->ArticleName }}</td>
            <td>{{ $Entry->Vendor }}</td>
            <td>{{ number_format( $Entry->Price, 2, ',', '.' ) }} {{ $Entry->Currency }}</td>
            <td>{{ $Entry->Amount }}</td>            
            <td>{{ $Entry->DeliveredAmount }}</td>
            <td>{{ $Entry->OrderText }}</td>
        </tr>
        @empty
           <tr><td colspan="7" class="text-center text-muted">Warenkorb ist leer</td></tr>
        @endforelse
        @endif
    </tbody>
    <tfoot>
        <tr>
            <td colspan="4" class="text-right"><strong>Gesamtpreis</strong></td>
            <td colspan="2" class="text-right">
                <strong id="TotalPrice">{{ number_format( $totalPrice, 2, ',', '.') }} {{ $Currency }}</strong>
            </td>
        </tr>
    </tfoot>
</table>

