@php
  $fmtDate = function($iso) {
    if (!$iso) return '—';
    try { return (new DateTimeImmutable($iso))->setTimezone(new DateTimeZone('Europe/Berlin'))->format('d.m.Y'); }
    catch(Throwable $e) { return '—'; }
  };
  $cell = fn($v) => ($v === null || $v === '' ? '–' : e($v));
@endphp

@if(empty($contracts))
  <div class="text-muted small">Keine Serviceverträge gefunden.</div>
@else
  @foreach($contracts as $idx => $c)
    <div class="border rounded p-2 mb-3">
      <div class="d-flex gap-2">
        <div class="pt-1">
          <input type="radio" name="crm_contract_id" value="{{ $c['id'] }}" @if($idx===0) checked @endif>
        </div>

        <div class="flex-grow-1">
          <div class="d-flex gap-2 mb-2">
            <div class="me-auto">
              <div><strong>Produkt:</strong> {{ $c['produkt'] ?? '—' }}</div>
              <div><strong>Kurzbeschreibung:</strong> {{ $c['kurzbeschreibung'] ?? '—' }}</div>
              <div>
                <strong>Vertrags-Nr:</strong> {{ $c['vertragsnr'] ?? '—' }}
                / <strong>Art:</strong> {{ $c['vertragsart'] ?? '—' }}
                / <strong>Support:</strong> {{ $c['supportart'] ?? '—' }}
              </div>
              <div><strong>Status:</strong> {{ $c['status'] ?? '—' }}</div>
              <div><strong>Zeitraum:</strong> {{ $fmtDate($c['beginn']) }} - {{ $fmtDate($c['ende']) }}</div>
            </div>

            <div class="text-end">
              {{-- Links (Kunde öffnen / Dokumente ggf später) --}}
              @if(!empty($c['crmUrl']))
                <a class="btn btn-sm btn-light mb-1" href="{{ $c['crmUrl'] }}" target="_blank" rel="noopener">Vertrag in CRM öffnen</a><br>
              @endif
              <a class="btn btn-sm btn-light mb-1" href="#" onclick="return false;">Öffne Vertragsdokumente</a><br>
            </div>
          </div>

          <div class="table-responsive">
            <table class="table table-sm table-bordered mb-0">
              <thead class="table-light">
                <tr>
                  <th style="width: 22%"></th>
                  <th class="text-center">P1</th>
                  <th class="text-center">P2</th>
                  <th class="text-center">P3</th>
                  <th class="text-center">P4</th>
                  <th class="text-center">P5</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th>Reaktion</th>
                  <td class="text-center">{{ $cell($c['sla']['reaction']['p1'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['reaction']['p2'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['reaction']['p3'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['reaction']['p4'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['reaction']['p5'] ?? null) }}</td>
                </tr>
                <tr>
                  <th>Vor Ort</th>
                  <td class="text-center">{{ $cell($c['sla']['onsite']['p1'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['onsite']['p2'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['onsite']['p3'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['onsite']['p4'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['onsite']['p5'] ?? null) }}</td>
                </tr>
                <tr>
                  <th>TimeToFix</th>
                  <td class="text-center">{{ $cell($c['sla']['timetofix']['p1'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['timetofix']['p2'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['timetofix']['p3'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['timetofix']['p4'] ?? null) }}</td>
                  <td class="text-center">{{ $cell($c['sla']['timetofix']['p5'] ?? null) }}</td>
                </tr>

                {{-- Servicetage / -zeiten: häufig gelten sie “global”; wir zeigen sie wie im Screenshot verteilt --}}
                <tr>
                  <th>Servicetage</th>
                  <td class="text-center">{{ $cell($c['sla']['servicetage']['p1'] ?? null) }}</td>
                  <td class="text-center">–</td>
                  <td class="text-center">–</td>
                  <td class="text-center">{{ $cell($c['sla']['servicetage']['p4'] ?? null) }}</td>
                  <td class="text-center">–</td>
                </tr>
                <tr>
                  <th>Servicezeiten</th>
                  <td class="text-center">{{ $cell($c['sla']['servicezeiten']['p1'] ?? null) }}</td>
                  <td class="text-center">–</td>
                  <td class="text-center">–</td>
                  <td class="text-center">{{ $cell($c['sla']['servicezeiten']['p4'] ?? null) }}</td>
                  <td class="text-center">–</td>
                </tr>
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>
  @endforeach
@endif
