<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareOverview File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;
/**
* WindowsMalwareOverview class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareOverview extends Entity
{

    /**
    * Gets the malwareCategorySummary
    * List of device counts per malware category
    *
    * @return WindowsMalwareCategoryCount|null The malwareCategorySummary
    */
    public function getMalwareCategorySummary()
    {
        if (array_key_exists("malwareCategorySummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareCategorySummary"], "\Microsoft\Graph\Model\WindowsMalwareCategoryCount") || is_null($this->_propDict["malwareCategorySummary"])) {
                return $this->_propDict["malwareCategorySummary"];
            } else {
                $this->_propDict["malwareCategorySummary"] = new WindowsMalwareCategoryCount($this->_propDict["malwareCategorySummary"]);
                return $this->_propDict["malwareCategorySummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareCategorySummary
    * List of device counts per malware category
    *
    * @param WindowsMalwareCategoryCount $val The value to assign to the malwareCategorySummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareCategorySummary($val)
    {
        $this->_propDict["malwareCategorySummary"] = $val;
         return $this;
    }
    /**
    * Gets the malwareDetectedDeviceCount
    * Count of devices with malware detected in the last 30 days
    *
    * @return int|null The malwareDetectedDeviceCount
    */
    public function getMalwareDetectedDeviceCount()
    {
        if (array_key_exists("malwareDetectedDeviceCount", $this->_propDict)) {
            return $this->_propDict["malwareDetectedDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareDetectedDeviceCount
    * Count of devices with malware detected in the last 30 days
    *
    * @param int $val The value of the malwareDetectedDeviceCount
    *
    * @return WindowsMalwareOverview
    */
    public function setMalwareDetectedDeviceCount($val)
    {
        $this->_propDict["malwareDetectedDeviceCount"] = $val;
        return $this;
    }

    /**
    * Gets the malwareExecutionStateSummary
    * List of device counts per malware execution state
    *
    * @return WindowsMalwareExecutionStateCount|null The malwareExecutionStateSummary
    */
    public function getMalwareExecutionStateSummary()
    {
        if (array_key_exists("malwareExecutionStateSummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareExecutionStateSummary"], "\Microsoft\Graph\Model\WindowsMalwareExecutionStateCount") || is_null($this->_propDict["malwareExecutionStateSummary"])) {
                return $this->_propDict["malwareExecutionStateSummary"];
            } else {
                $this->_propDict["malwareExecutionStateSummary"] = new WindowsMalwareExecutionStateCount($this->_propDict["malwareExecutionStateSummary"]);
                return $this->_propDict["malwareExecutionStateSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareExecutionStateSummary
    * List of device counts per malware execution state
    *
    * @param WindowsMalwareExecutionStateCount $val The value to assign to the malwareExecutionStateSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareExecutionStateSummary($val)
    {
        $this->_propDict["malwareExecutionStateSummary"] = $val;
         return $this;
    }

    /**
    * Gets the malwareNameSummary
    * List of device counts per malware
    *
    * @return WindowsMalwareNameCount|null The malwareNameSummary
    */
    public function getMalwareNameSummary()
    {
        if (array_key_exists("malwareNameSummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareNameSummary"], "\Microsoft\Graph\Model\WindowsMalwareNameCount") || is_null($this->_propDict["malwareNameSummary"])) {
                return $this->_propDict["malwareNameSummary"];
            } else {
                $this->_propDict["malwareNameSummary"] = new WindowsMalwareNameCount($this->_propDict["malwareNameSummary"]);
                return $this->_propDict["malwareNameSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareNameSummary
    * List of device counts per malware
    *
    * @param WindowsMalwareNameCount $val The value to assign to the malwareNameSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareNameSummary($val)
    {
        $this->_propDict["malwareNameSummary"] = $val;
         return $this;
    }

    /**
    * Gets the malwareSeveritySummary
    * List of active malware counts per malware severity
    *
    * @return WindowsMalwareSeverityCount|null The malwareSeveritySummary
    */
    public function getMalwareSeveritySummary()
    {
        if (array_key_exists("malwareSeveritySummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareSeveritySummary"], "\Microsoft\Graph\Model\WindowsMalwareSeverityCount") || is_null($this->_propDict["malwareSeveritySummary"])) {
                return $this->_propDict["malwareSeveritySummary"];
            } else {
                $this->_propDict["malwareSeveritySummary"] = new WindowsMalwareSeverityCount($this->_propDict["malwareSeveritySummary"]);
                return $this->_propDict["malwareSeveritySummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareSeveritySummary
    * List of active malware counts per malware severity
    *
    * @param WindowsMalwareSeverityCount $val The value to assign to the malwareSeveritySummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareSeveritySummary($val)
    {
        $this->_propDict["malwareSeveritySummary"] = $val;
         return $this;
    }

    /**
    * Gets the malwareStateSummary
    * List of device counts per malware state
    *
    * @return WindowsMalwareStateCount|null The malwareStateSummary
    */
    public function getMalwareStateSummary()
    {
        if (array_key_exists("malwareStateSummary", $this->_propDict)) {
            if (is_a($this->_propDict["malwareStateSummary"], "\Microsoft\Graph\Model\WindowsMalwareStateCount") || is_null($this->_propDict["malwareStateSummary"])) {
                return $this->_propDict["malwareStateSummary"];
            } else {
                $this->_propDict["malwareStateSummary"] = new WindowsMalwareStateCount($this->_propDict["malwareStateSummary"]);
                return $this->_propDict["malwareStateSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the malwareStateSummary
    * List of device counts per malware state
    *
    * @param WindowsMalwareStateCount $val The value to assign to the malwareStateSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setMalwareStateSummary($val)
    {
        $this->_propDict["malwareStateSummary"] = $val;
         return $this;
    }

    /**
    * Gets the osVersionsSummary
    * List of device counts with malware per windows OS version
    *
    * @return OsVersionCount|null The osVersionsSummary
    */
    public function getOsVersionsSummary()
    {
        if (array_key_exists("osVersionsSummary", $this->_propDict)) {
            if (is_a($this->_propDict["osVersionsSummary"], "\Microsoft\Graph\Model\OsVersionCount") || is_null($this->_propDict["osVersionsSummary"])) {
                return $this->_propDict["osVersionsSummary"];
            } else {
                $this->_propDict["osVersionsSummary"] = new OsVersionCount($this->_propDict["osVersionsSummary"]);
                return $this->_propDict["osVersionsSummary"];
            }
        }
        return null;
    }

    /**
    * Sets the osVersionsSummary
    * List of device counts with malware per windows OS version
    *
    * @param OsVersionCount $val The value to assign to the osVersionsSummary
    *
    * @return WindowsMalwareOverview The WindowsMalwareOverview
    */
    public function setOsVersionsSummary($val)
    {
        $this->_propDict["osVersionsSummary"] = $val;
         return $this;
    }
    /**
    * Gets the totalDistinctMalwareCount
    * Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
    *
    * @return int|null The totalDistinctMalwareCount
    */
    public function getTotalDistinctMalwareCount()
    {
        if (array_key_exists("totalDistinctMalwareCount", $this->_propDict)) {
            return $this->_propDict["totalDistinctMalwareCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the totalDistinctMalwareCount
    * Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the totalDistinctMalwareCount
    *
    * @return WindowsMalwareOverview
    */
    public function setTotalDistinctMalwareCount($val)
    {
        $this->_propDict["totalDistinctMalwareCount"] = $val;
        return $this;
    }
    /**
    * Gets the totalMalwareCount
    * Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
    *
    * @return int|null The totalMalwareCount
    */
    public function getTotalMalwareCount()
    {
        if (array_key_exists("totalMalwareCount", $this->_propDict)) {
            return $this->_propDict["totalMalwareCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the totalMalwareCount
    * Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the totalMalwareCount
    *
    * @return WindowsMalwareOverview
    */
    public function setTotalMalwareCount($val)
    {
        $this->_propDict["totalMalwareCount"] = $val;
        return $this;
    }
}
